/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.issue.issuetype.IssueTypeId;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueTypeManager;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIssueTypeManagerImpl
implements UserIssueTypeManager {
    private static final Logger log = LoggerFactory.getLogger(UserIssueTypeManagerImpl.class);
    private static final String LAST_USED_ISSUE_TYPE_KEY = "user.last.issue.type.id";
    private static final String LAST_USED_SUBTASK_ISSUE_TYPE_KEY = "user.last.subtask.issue.type.id";
    private final UserPreferencesManager userPreferencesManager;

    public UserIssueTypeManagerImpl(UserPreferencesManager userPreferencesManager) {
        this.userPreferencesManager = userPreferencesManager;
    }

    public void setLastUsedIssueTypeId(@Nullable ApplicationUser user, IssueTypeId lastUsedIssueTypeId) {
        this.setIssueType(user, LAST_USED_ISSUE_TYPE_KEY, lastUsedIssueTypeId.getId());
    }

    public void setLastUsedSubtaskIssueTypeId(@Nullable ApplicationUser user, IssueTypeId lastUsedSubtaskIssueTypeId) {
        this.setIssueType(user, LAST_USED_SUBTASK_ISSUE_TYPE_KEY, lastUsedSubtaskIssueTypeId.getId());
    }

    public Optional<IssueTypeId> getLastUsedIssueTypeId(@Nullable ApplicationUser user) {
        return this.getIssueTypeId(user, LAST_USED_ISSUE_TYPE_KEY);
    }

    public Optional<IssueTypeId> getLastUsedSubtaskIssueTypeId(@Nullable ApplicationUser user) {
        return this.getIssueTypeId(user, LAST_USED_SUBTASK_ISSUE_TYPE_KEY);
    }

    private Optional<IssueTypeId> getIssueTypeId(ApplicationUser user, String prefKey) {
        if (user == null) {
            return Optional.empty();
        }
        ExtendedPreferences prefs = this.userPreferencesManager.getExtendedPreferences(user);
        return Optional.ofNullable(prefs.getString(prefKey)).map(IssueTypeId::new);
    }

    private void setIssueType(ApplicationUser user, String prefKey, String issueTypeId) {
        if (user == null) {
            return;
        }
        ExtendedPreferences prefs = this.userPreferencesManager.getExtendedPreferences(user);
        try {
            prefs.setString(prefKey, issueTypeId);
        }
        catch (AtlassianCoreException e) {
            log.warn("Unable to store last used issue type for user.", (Throwable)e);
        }
    }
}

