/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.util;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeEntityUtil {
    private final String taskName;
    private final EntityEngine entityEngine;
    private static final Logger log = Logger.getLogger(UpgradeEntityUtil.class);

    public UpgradeEntityUtil(String taskName, EntityEngine entityEngine) {
        this.taskName = taskName;
        this.entityEngine = entityEngine;
    }

    private void log(Level level, String message) {
        String logMessage = String.format("%s: %s", this.taskName, message);
        this.doLogInt(level, logMessage);
    }

    @VisibleForTesting
    void doLogInt(Level level, String logMessage) {
        log.log((Priority)level, (Object)logMessage);
    }

    public void deleteEntityByCondition(final String entityName, EntityCondition entityCondition) {
        Select.from(entityName).whereCondition(entityCondition).runWith(this.entityEngine).visitWith(new Visitor<GenericValue>(){

            public void visit(GenericValue element) {
                UpgradeEntityUtil.this.logEntity(entityName, element, "DELETING");
            }
        });
        this.entityEngine.delete(Delete.from(entityName).whereCondition(entityCondition));
    }

    public void logEntity(String entityName, GenericValue element, String action) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("entityName", (Object)entityName);
            jsonObject.put("fields", (Object)Maps.transformValues((Map)element.getAllFields(), (Function)new Function<Object, String>(){

                public String apply(@Nullable Object input) {
                    return input != null ? input.toString() : "NULL";
                }
            }));
            this.log(Level.WARN, action + " " + jsonObject.toString());
        }
        catch (JSONException e) {
            this.log(Level.ERROR, "Unable to log for " + element.toString());
            log.error((Object)"This should never happen", (Throwable)e);
        }
    }
}

