/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.fugue.Option;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.util.dbc.Assertions;

final class Move6xLicenseTo70Store
extends MigrationTask {
    private static final boolean EVENT_SHOWS_IN_CLOUD_LOG = false;
    private final LicenseDao dao;

    Move6xLicenseTo70Store(LicenseDao dao) {
        this.dao = (LicenseDao)Assertions.notNull((String)"dao", (Object)dao);
    }

    @Override
    MigrationState migrate(MigrationState state, boolean licenseSuppliedByUser) {
        state = state.withAfterSaveTask(this.dao::remove6xLicense);
        if (!licenseSuppliedByUser) {
            Option<License> oldLicense = this.dao.get6xLicense();
            if (oldLicense.isDefined()) {
                License license = (License)oldLicense.get();
                if (state.licenses().canAdd(license)) {
                    AuditEntry auditEntry = new AuditEntry(Move6xLicenseTo70Store.class, "Moved license location", "Moved license from old location in application properties to new location in license table", AssociatedItem.Type.LICENSE, license.getSEN(), false, new ChangedValue[0]);
                    return state.changeLicenses(licenses -> licenses.addLicense(license)).log(auditEntry);
                }
                return state.log(Move6xLicenseTo70Store.auditEntry("Not moving license location", "Incompatible license already exists in license table."));
            }
            return state.log(Move6xLicenseTo70Store.auditEntry("Not moving license location", "No valid existing license present in data."));
        }
        return state.log(Move6xLicenseTo70Store.auditEntry("Not moving license location", "License entered during import supersedes all licenses in data."));
    }

    private static AuditEntry auditEntry(String summary, String description) {
        return new AuditEntry(Move6xLicenseTo70Store.class, summary, description, AssociatedItem.Type.LICENSE, null, false, new ChangedValue[0]);
    }
}

