/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import java.io.File;
import java.nio.file.Files;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;
import org.apache.commons.io.FilenameUtils;

public class UpgradeTask_Build72002
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build72002.class);
    private static final String TAG = UpgradeTask_Build72002.class.getSimpleName();
    private final String PNG_EXTENSION = ".png";
    private final AvatarManager avatarManager;

    public UpgradeTask_Build72002(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    @Override
    public String getBuildNumber() {
        return "72002";
    }

    @Override
    public String getShortDescription() {
        return "Removing old issue type icon files (PNGs)";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        File avatarBaseDirectory = this.avatarManager.getAvatarBaseDirectory();
        for (Avatar avatar : this.avatarManager.getAllSystemAvatars(IconType.ISSUE_TYPE_ICON_TYPE)) {
            String filename = FilenameUtils.removeExtension((String)avatar.getFileName());
            for (Avatar.Size size : Avatar.Size.values()) {
                String filenamePng = size.getParam() + "_" + filename + ".png";
                String filenamePng2 = size.getParam() + "_images_icons_issuetypes_" + filename + ".png";
                try {
                    File file = new File(avatarBaseDirectory, filenamePng);
                    Files.deleteIfExists(file.toPath());
                    File file2 = new File(avatarBaseDirectory, filenamePng2);
                    Files.deleteIfExists(file2.toPath());
                }
                catch (Exception e) {
                    log.error((Object)TAG, (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

