/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.model.querydsl.QNodeAssociation;
import com.atlassian.jira.model.querydsl.QVersion;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build71001
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build71001.class);
    private final DbConnectionManager dbConnectionManager;

    public UpgradeTask_Build71001(DbConnectionManager dbConnectionManager) {
        this.dbConnectionManager = dbConnectionManager;
    }

    @Override
    public String getBuildNumber() {
        return "71001";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return "Deleting invalid version associations.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        long associationsDeleted = this.dbConnectionManager.executeQuery(callback -> {
            QNodeAssociation na = new QNodeAssociation("na");
            QVersion v = new QVersion("v");
            long deletedCount = callback.delete((RelationalPath<?>)na).where((Predicate)na.sourceNodeEntity.eq((Object)"Issue").and((Predicate)na.sinkNodeEntity.eq((Object)"Version")).and((Predicate)na.sinkNodeId.notIn((SubQueryExpression)SQLExpressions.select(v.id).from((Expression)v)))).execute();
            log.info("Deleted {} invalid issue to version associations.", (Object)deletedCount);
            return deletedCount;
        });
        if (associationsDeleted > 0L) {
            this.getReindexRequestService().requestReindex(ReindexRequestType.DELAYED, EnumSet.of(AffectedIndex.ISSUE), EnumSet.noneOf(SharedEntityType.class));
        }
    }
}

