/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.propertyset.CachingOfBizPropertyEntryStore;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build70025
extends AbstractImmediateUpgradeTask {
    private static final String BUILD_NUMBER = "70025";
    private static final int MAX_ROWS_IN_BATCH = 900;
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build70025.class);
    private final DbConnectionManager dbConnectionManager;

    public UpgradeTask_Build70025(DbConnectionManager dbConnectionManager) {
        this.dbConnectionManager = dbConnectionManager;
    }

    @Override
    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Remove jira.user.locale preference if current value is -1";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.dbConnectionManager.execute(dbConnection -> {
            dbConnection.setAutoCommit(false);
            List<Long> propertyIds = this.getMinusOneUserLocalePropertyIds(dbConnection);
            if (!propertyIds.isEmpty()) {
                LOG.debug("Removing {} user locale preferences with value -1", (Object)propertyIds.size());
                List batches = Lists.partition(propertyIds, (int)900);
                for (int i = 0; i < batches.size(); ++i) {
                    LOG.debug("Deleting batch {} of {}", (Object)(i + 1), (Object)batches.size());
                    this.deleteMinusOneUserLocaleProperty((List)batches.get(i), dbConnection);
                }
            }
            dbConnection.commit();
        });
        OfBizPropertyEntryStore entryStore = (OfBizPropertyEntryStore)ComponentAccessor.getComponent(OfBizPropertyEntryStore.class);
        if (entryStore instanceof CachingOfBizPropertyEntryStore) {
            ((CachingOfBizPropertyEntryStore)entryStore).refreshAll();
        }
    }

    private List<Long> getMinusOneUserLocalePropertyIds(DbConnection dbConnection) {
        QOSPropertyEntry propertyEntry = QOSPropertyEntry.O_S_PROPERTY_ENTRY;
        QOSPropertyString propertyString = QOSPropertyString.O_S_PROPERTY_STRING;
        List propertyIds = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(propertyString.id).from((Expression)propertyEntry)).join((EntityPath)propertyString)).on((Predicate)propertyEntry.id.eq(propertyString.id))).where((Predicate)propertyEntry.propertyKey.eq((Object)"jira.user.locale").and((Predicate)propertyString.value.like("-1")))).fetch();
        return propertyIds;
    }

    private void deleteMinusOneUserLocaleProperty(List<Long> ids, DbConnection dbConnection) {
        QOSPropertyEntry propertyEntry = QOSPropertyEntry.O_S_PROPERTY_ENTRY;
        QOSPropertyString propertyString = QOSPropertyString.O_S_PROPERTY_STRING;
        dbConnection.delete((RelationalPath<?>)propertyString).where((Predicate)propertyString.id.in(ids)).execute();
        dbConnection.delete((RelationalPath<?>)propertyEntry).where((Predicate)propertyEntry.id.in(ids)).execute();
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

