/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.QAvatar;
import com.atlassian.jira.model.querydsl.QIssueType;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build70024
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build70024.class);
    static final int TRUE = 1;
    static final String ISSUE_TYPE_AVATAR = "issuetype";
    static final String PROJECT_AVATAR = "project";
    static final String USER_AVATAR = "user";
    static final String SVG_CONTENT_TYPE = "image/svg+xml";
    static final String DEFAULT_PROJECT_AVATAR_KEY = "jira.avatar.default.id";
    static final String DEFAULT_PROJECT_AVATAR_NAME = "default.svg";
    static final Map<String, String> issueTypeIconsToReplace = ImmutableMap.builder().put((Object)"subtask_alternate.png", (Object)"subtask.png").put((Object)"task_agile.png", (Object)"task.png").put((Object)"delete.png", (Object)"remove_feature.png").put((Object)"blank.png", (Object)"genericissue.png").put((Object)"all_unassigned.png", (Object)"genericissue.png").build();
    static final Map<String, String> issueTypeIconsToRename = ImmutableMap.builder().put((Object)"task.png", (Object)"task.svg").put((Object)"subtask.png", (Object)"subtask.svg").put((Object)"story.png", (Object)"story.svg").put((Object)"improvement.png", (Object)"improvement.svg").put((Object)"sales.png", (Object)"sales.svg").put((Object)"health.png", (Object)"design_task.svg").put((Object)"remove_feature.png", (Object)"remove_feature.svg").put((Object)"requirement.png", (Object)"requirement.svg").put((Object)"newfeature.png", (Object)"newfeature.svg").put((Object)"exclamation.png", (Object)"exclamation.svg").put((Object)"documentation.png", (Object)"documentation.svg").put((Object)"defect.png", (Object)"defect.svg").put((Object)"epic.png", (Object)"epic.svg").put((Object)"genericissue.png", (Object)"genericissue.svg").put((Object)"bug.png", (Object)"bug.svg").put((Object)"undefined.png", (Object)"question.svg").build();
    static final Map<String, String> defaultIssueTypeIconsToRename = ImmutableMap.builder().put((Object)"/images/icons/issuetypes/bug.png", (Object)"bug.svg").put((Object)"/images/icons/issuetypes/newfeature.png", (Object)"newfeature.svg").put((Object)"/images/icons/issuetypes/task.png", (Object)"task.svg").put((Object)"/images/icons/issuetypes/improvement.png", (Object)"improvement.svg").put((Object)"/images/icons/issuetypes/subtask_alternate.png", (Object)"subtask.svg").put((Object)"/images/icons/issuetypes/subtask.png", (Object)"subtask.svg").put((Object)"/images/icons/issuetypes/genericissue.png", (Object)"genericissue.svg").put((Object)"/images/icons/issuetypes/epic.png", (Object)"epic.svg").put((Object)"/images/icons/issuetypes/story.png", (Object)"story.svg").put((Object)"/images/icons/issuetypes/sales.png", (Object)"sales.svg").put((Object)"/images/icons/ico_epic.png", (Object)"epic.svg").put((Object)"/images/icons/ico_story.png", (Object)"story.svg").put((Object)"/download/resources/com.pyxis.greenhopper.jira:greenhopper-webactions/images/ico_epic.png", (Object)"epic.svg").put((Object)"/download/resources/com.pyxis.greenhopper.jira:greenhopper-webactions/images/ico_defect.png", (Object)"defect.svg").put((Object)"/download/resources/com.pyxis.greenhopper.jira:greenhopper-webactions/images/ico_bug.png", (Object)"bug.svg").put((Object)"/download/resources/com.pyxis.greenhopper.jira:greenhopper-webactions/images/ico_story.png", (Object)"story.svg").build();
    static final List<String> issueTypeIconsToAdd = ImmutableList.of((Object)"development_task.svg", (Object)"feedback.svg", (Object)"request_access.svg");
    static final Map<String, String> projectIconsToRename = ImmutableMap.builder().put((Object)"cloud.png", (Object)"cloud.svg").put((Object)"config.png", (Object)"spanner.svg").put((Object)"disc.png", (Object)"cd.svg").put((Object)"eamesbird.png", (Object)"bird.svg").put((Object)"finance.png", (Object)"money.svg").put((Object)"hand.png", (Object)"mouse-hand.svg").put((Object)"kangaroo.png", (Object)"koala.svg").put((Object)"new_monster.png", (Object)"yeti.svg").put((Object)"power.png", (Object)"power.svg").put((Object)"rainbow.png", (Object)"nature.svg").put((Object)"refresh.png", (Object)"refresh.svg").put((Object)"rocket.png", (Object)"rocket.svg").put((Object)"servicedesk.png", (Object)"phone.svg").put((Object)"settings.png", (Object)"settings.svg").put((Object)"storm.png", (Object)"storm.svg").put((Object)"travel.png", (Object)"plane.svg").build();
    static final List<String> projectIconsToAdd = ImmutableList.of((Object)"default.svg", (Object)"code.svg", (Object)"coffee.svg", (Object)"design.svg", (Object)"drill.svg", (Object)"food.svg", (Object)"notes.svg", (Object)"red-flag.svg", (Object)"science.svg", (Object)"spanner.svg", (Object)"support.svg");
    static final Map<String, String> userIconsToUpdate = ImmutableMap.builder().put((Object)"Avatar-default.png", (Object)"Avatar-default.svg").build();
    static final List<String> userIconsToAdd = ImmutableList.of((Object)"bull.svg", (Object)"cat.svg", (Object)"dog.svg", (Object)"female_1.svg", (Object)"female_2.svg", (Object)"female_3.svg", (Object)"female_4.svg", (Object)"ghost.svg", (Object)"male_1.svg", (Object)"male_2.svg", (Object)"male_3.svg", (Object)"male_4.svg", (Object[])new String[]{"male_5.svg", "male_6.svg", "male_8.svg", "owl.svg", "pirate.svg", "robot.svg", "vampire.svg"});
    private final DbConnectionManager dbConnectionManager;

    public UpgradeTask_Build70024(DbConnectionManager dbConnectionManager) {
        this.dbConnectionManager = dbConnectionManager;
    }

    @Override
    public String getBuildNumber() {
        return "70024";
    }

    @Override
    public String getShortDescription() {
        return "Replacing system avatars with new SVG icons.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.upgradeIssueTypeIcons();
        this.upgradeProjectIcons();
        this.upgradeUserIcons();
    }

    private void upgradeIssueTypeIcons() {
        this.dbConnectionManager.execute(callback -> {
            callback.setAutoCommit(false);
            Long fallBackIconId = this.prepareFallBackIconForIssueType(callback);
            if (fallBackIconId == null) {
                log.warn("No system avatar icons found for issue types. No icons will be replaced.");
                return;
            }
            QAvatar a = QAvatar.AVATAR;
            QIssueType it = QIssueType.ISSUE_TYPE;
            Map iconsToReplace = (Map)((SQLQuery)((SQLQuery)((SQLQuery)callback.newSqlQuery().from((Expression)a)).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.in(issueTypeIconsToReplace.keySet())))).groupBy((Expression)a.fileName)).transform(GroupBy.groupBy((Expression)a.fileName).as((Expression)a.id.min()));
            Map replacementIcons = (Map)((SQLQuery)((SQLQuery)((SQLQuery)callback.newSqlQuery().from((Expression)a)).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.in(issueTypeIconsToReplace.values())))).groupBy((Expression)a.fileName)).transform(GroupBy.groupBy((Expression)a.fileName).as((Expression)a.id.min()));
            for (Map.Entry<String, String> entry : issueTypeIconsToReplace.entrySet()) {
                String iconToReplace = entry.getKey();
                String replacementIcon = entry.getValue();
                Long iconToReplaceId = (Long)iconsToReplace.get(iconToReplace);
                Long replacementIconId = (Long)replacementIcons.get(replacementIcon);
                if (iconToReplaceId == null) {
                    log.warn("System icon: " + iconToReplace + " is not present.");
                    continue;
                }
                if (replacementIconId == null) {
                    log.warn("System icon: " + replacementIcon + " is not present. Using fallback icon.");
                    replacementIconId = fallBackIconId;
                }
                callback.update((RelationalPath<?>)it).where((Predicate)it.avatar.eq((Object)iconToReplaceId)).set(it.avatar, (Object)replacementIconId).execute();
            }
            callback.delete((RelationalPath<?>)a).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.in(issueTypeIconsToReplace.keySet()))).execute();
            for (Map.Entry<String, String> entry : issueTypeIconsToRename.entrySet()) {
                String oldIconName = entry.getKey();
                String newIconName = entry.getValue();
                callback.update((RelationalPath<?>)a).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)oldIconName))).set((Path)a.fileName, (Object)newIconName).set((Path)a.contentType, (Object)SVG_CONTENT_TYPE).execute();
            }
            for (String string : issueTypeIconsToAdd) {
                long count = ((SQLQuery)((SQLQuery)callback.newSqlQuery().select((Expression)a).from((Expression)a)).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)string)).and((Predicate)a.contentType.eq((Object)SVG_CONTENT_TYPE)))).fetchCount();
                if (count != 0L) continue;
                callback.insert(a).set((Path)a.fileName, string).set((Path)a.contentType, SVG_CONTENT_TYPE).set((Path)a.avatarType, ISSUE_TYPE_AVATAR).set((Path)a.systemAvatar, (Object)1).withId().execute();
            }
            for (Map.Entry entry : defaultIssueTypeIconsToRename.entrySet()) {
                String oldIconUrl = (String)entry.getKey();
                String newIconFileName = (String)entry.getValue();
                callback.update((RelationalPath<?>)it).where((Predicate)it.avatar.isNull().and((Predicate)it.iconurl.eq((Object)oldIconUrl))).set(it.avatar, (Expression)((SQLQuery)SQLExpressions.select(a.id).from((Expression)a)).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)newIconFileName)))).execute();
            }
            callback.commit();
        });
    }

    private Long prepareFallBackIconForIssueType(DbConnection callback) {
        QAvatar a = QAvatar.AVATAR;
        Optional<Object> undefinedIconId = Optional.ofNullable(((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)callback.newSqlQuery().select(a.id).from((Expression)a)).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)"undefined.png")))).orderBy(a.id.asc())).limit(1L)).fetchOne());
        return undefinedIconId.orElseGet(() -> (Long)((SQLQuery)((SQLQuery)((SQLQuery)callback.newSqlQuery().select(a.id).from((Expression)a)).where((Predicate)a.avatarType.eq((Object)ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)))).limit(1L)).fetchOne());
    }

    private void upgradeProjectIcons() {
        this.dbConnectionManager.execute(callback -> {
            callback.setAutoCommit(false);
            QAvatar a = QAvatar.AVATAR;
            for (Map.Entry<String, String> projectIconToRenameEntry : projectIconsToRename.entrySet()) {
                String oldIconName = projectIconToRenameEntry.getKey();
                String newIconName = projectIconToRenameEntry.getValue();
                callback.update((RelationalPath<?>)a).where((Predicate)a.avatarType.eq((Object)PROJECT_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)oldIconName))).set((Path)a.fileName, (Object)newIconName).set((Path)a.contentType, (Object)SVG_CONTENT_TYPE).execute();
            }
            for (String iconToAdd : projectIconsToAdd) {
                long count = ((SQLQuery)((SQLQuery)callback.newSqlQuery().select((Expression)a).from((Expression)a)).where((Predicate)a.avatarType.eq((Object)PROJECT_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)iconToAdd)).and((Predicate)a.contentType.eq((Object)SVG_CONTENT_TYPE)))).fetchCount();
                if (count != 0L) continue;
                callback.insert(a).set((Path)a.fileName, iconToAdd).set((Path)a.contentType, SVG_CONTENT_TYPE).set((Path)a.avatarType, PROJECT_AVATAR).set((Path)a.systemAvatar, (Object)1).withId().execute();
            }
            QOSPropertyEntry entry = QOSPropertyEntry.O_S_PROPERTY_ENTRY;
            QOSPropertyString property = QOSPropertyString.O_S_PROPERTY_STRING;
            Long defaultProjectAvatarId = (Long)((SQLQuery)((SQLQuery)((SQLQuery)callback.newSqlQuery().select(a.id).from((Expression)a)).where((Predicate)a.avatarType.eq((Object)PROJECT_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)DEFAULT_PROJECT_AVATAR_NAME)))).limit(1L)).fetchOne();
            callback.update((RelationalPath<?>)property).where((Predicate)property.id.eq((Expression)((SQLQuery)SQLExpressions.select(entry.id).from((Expression)entry)).where((Predicate)entry.propertyKey.eq((Object)DEFAULT_PROJECT_AVATAR_KEY)))).set((Path)property.value, (Object)defaultProjectAvatarId.toString()).execute();
            callback.commit();
        });
    }

    private void upgradeUserIcons() {
        this.dbConnectionManager.execute(callback -> {
            callback.setAutoCommit(false);
            QAvatar a = QAvatar.AVATAR;
            for (String string : userIconsToAdd) {
                long count = ((SQLQuery)((SQLQuery)callback.newSqlQuery().select((Expression)a).from((Expression)a)).where((Predicate)a.avatarType.eq((Object)USER_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)string)).and((Predicate)a.contentType.eq((Object)SVG_CONTENT_TYPE)))).fetchCount();
                if (count != 0L) continue;
                callback.insert(a).set((Path)a.fileName, string).set((Path)a.contentType, SVG_CONTENT_TYPE).set((Path)a.avatarType, USER_AVATAR).set((Path)a.systemAvatar, (Object)1).withId().execute();
            }
            for (Map.Entry entry : userIconsToUpdate.entrySet()) {
                String oldIconName = (String)entry.getKey();
                String newIconName = (String)entry.getValue();
                callback.update((RelationalPath<?>)a).where((Predicate)a.avatarType.eq((Object)USER_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)oldIconName))).set((Path)a.fileName, (Object)newIconName).set((Path)a.contentType, (Object)SVG_CONTENT_TYPE).execute();
            }
            callback.commit();
        });
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }
}

