/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.subscription.DefaultSubscriptionManager;
import com.atlassian.jira.scheduler.JiraParameterMapSerializer;
import com.atlassian.jira.scheduler.OfBizClusteredJob;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.CronExpressionFixer;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.caesium.impl.ImmutableClusteredJob;
import com.atlassian.scheduler.caesium.spi.ClusteredJob;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build70011
extends AbstractImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build70011.class);
    static final String JOB_RUNNER_KEY = DefaultSubscriptionManager.class.getName();
    static final String SUBSCRIPTION_PREFIX = DefaultSubscriptionManager.class.getName();
    static final String SUBSCRIPTION_IDENTIFIER = "SUBSCRIPTION_ID";
    static final String FILTER_GROUP_NAME = "SEND_SUBSCRIPTION";
    static final String FILTER_NAME_PREFIX = "SUBSCRIPTION_";
    private final EntityEngine entityEngine;
    private final SchedulerService schedulerService;
    private final JiraParameterMapSerializer jiraParameterMapSerializer;

    public UpgradeTask_Build70011(EntityEngine entityEngine, SchedulerService schedulerService, JiraParameterMapSerializer jiraParameterMapSerializer) {
        this.entityEngine = entityEngine;
        this.schedulerService = schedulerService;
        this.jiraParameterMapSerializer = jiraParameterMapSerializer;
    }

    @Override
    public String getBuildNumber() {
        return "70011";
    }

    @Override
    public String getShortDescription() {
        return "Adding filter subscriptions to atlassian-scheduler";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (this.hasRun("com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6307")) {
            LOG.info("This upgrade task already ran as 6307; skipping it...");
        } else if (this.hasRun("com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6317")) {
            LOG.info("This upgrade task already ran as 6317; skipping it...");
        } else {
            this.upgradeFilterSubscriptionSchedules();
        }
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    private boolean hasRun(String upgradeClassName) {
        return Select.id().from("UpgradeHistory").whereEqual("upgradeclass", upgradeClassName).runWith(this.entityEngine).count() > 0L;
    }

    void upgradeFilterSubscriptionSchedules() throws GenericEntityException, SchedulerServiceException {
        List jobTriggers = Select.from("QRTZTriggers").whereEqual("triggerGroup", FILTER_GROUP_NAME).runWith(this.entityEngine).asList();
        for (GenericValue jobTrigger : jobTriggers) {
            String triggerName = jobTrigger.getString("triggerName");
            Long id = Long.parseLong(triggerName.substring(FILTER_NAME_PREFIX.length()));
            Schedule schedule = this.getSchedule(jobTrigger, triggerName);
            if (schedule == null) continue;
            this.createFilterSubscriptionSchedule(id, schedule);
        }
    }

    private void createFilterSubscriptionSchedule(Long id, Schedule schedule) throws SchedulerServiceException {
        JobId jobId = UpgradeTask_Build70011.toJobId(id);
        Date nextRunTime = this.schedulerService.calculateNextRunTime(schedule);
        ImmutableClusteredJob clusteredJob = ImmutableClusteredJob.builder().jobId(jobId).jobRunnerKey(JobRunnerKey.of((String)JOB_RUNNER_KEY)).nextRunTime(nextRunTime).schedule(schedule).parameters(this.toRawParameters(id)).build();
        Delete.from(Entity.CLUSTERED_JOB).whereEqual("jobId", jobId.toString()).execute(this.entityEngine);
        this.entityEngine.createValue(Entity.CLUSTERED_JOB, new OfBizClusteredJob(null, (ClusteredJob)clusteredJob));
    }

    private Schedule getSchedule(GenericValue jobTrigger, String triggerName) {
        String triggerType = jobTrigger.getString("triggerType");
        if ("SIMPLE".equals(triggerType)) {
            return this.getSimpleTriggerSchedule(jobTrigger, triggerName);
        }
        if ("CRON".equals(triggerType)) {
            return this.getCronTriggerSchedule(jobTrigger, triggerName);
        }
        LOG.error("Unable to migrate filter subscription trigger '" + triggerName + "'; unsupported trigger type '" + triggerType + '\'');
        return null;
    }

    private Schedule getSimpleTriggerSchedule(GenericValue jobTrigger, String triggerName) {
        GenericValue simpleTrigger = this.getTriggerDetails("QRTZSimpleTriggers", jobTrigger);
        if (simpleTrigger == null) {
            LOG.error("Missing simple trigger data for filter subscription trigger '" + triggerName + '\'');
            return null;
        }
        Long repeatInterval = simpleTrigger.getLong("repeatInterval");
        if (repeatInterval == null) {
            LOG.error("Missing repeatInterval for filter subscription simple trigger '" + triggerName + '\'');
            return null;
        }
        return Schedule.forInterval((long)repeatInterval, null);
    }

    private Schedule getCronTriggerSchedule(GenericValue jobTrigger, String triggerName) {
        GenericValue cronTrigger = this.getTriggerDetails("QRTZCronTriggers", jobTrigger);
        if (cronTrigger == null) {
            LOG.error("Missing cron trigger data for filter subscription trigger '" + triggerName + '\'');
            return null;
        }
        String cronExpression = cronTrigger.getString("cronExpression");
        if (cronExpression == null) {
            LOG.error("Missing cronExpression for filter subscription cron trigger '" + triggerName + '\'');
            return null;
        }
        return Schedule.forCronExpression((String)UpgradeTask_Build70011.repairCronExpression(cronExpression, triggerName));
    }

    @Nullable
    private GenericValue getTriggerDetails(String entityName, GenericValue trigger) {
        List triggerDetails = Select.from(entityName).whereEqual("trigger", trigger.getLong("id")).runWith(this.entityEngine).asList();
        return triggerDetails.isEmpty() ? null : (GenericValue)triggerDetails.get(0);
    }

    private byte[] toRawParameters(Long subscriptionId) {
        try {
            return this.jiraParameterMapSerializer.serializeParameters((Map)ImmutableMap.of((Object)SUBSCRIPTION_IDENTIFIER, (Object)subscriptionId));
        }
        catch (SchedulerServiceException sse) {
            throw new SchedulerRuntimeException("Unable to serialize parameter map", (Throwable)sse);
        }
    }

    private static JobId toJobId(Long subId) {
        return JobId.of((String)(SUBSCRIPTION_PREFIX + ':' + subId));
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "70010";
    }

    private static String repairCronExpression(String cronExpression, String triggerName) {
        CronExpressionFixer.Result result = CronExpressionFixer.repairCronExpression(cronExpression);
        String repaired = result.getNewCronExpression().orElse(null);
        if (repaired != null) {
            LOG.warn("Repairing cron expression for filter subscription '{}': '{}' => '{}'", new Object[]{triggerName, cronExpression, repaired});
            return repaired;
        }
        return result.getCronSyntaxException().map(cse -> UpgradeTask_Build70011.handleFailedRepair(triggerName, cronExpression, (Exception)((Object)cse))).orElse(cronExpression);
    }

    private static String handleFailedRepair(String triggerName, String cronExpression, Exception cse) {
        LOG.warn("Reverting filter subscription '{}' to default schedule: '{}' => '{}': {}", new Object[]{triggerName, cronExpression, "0 0 1 ? * *", cse.toString()});
        return "0 0 1 ? * *";
    }
}

