/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.subscription.DefaultSubscriptionManager;
import com.atlassian.jira.scheduler.OfBizClusteredJob;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.CronExpressionFixer;
import com.atlassian.scheduler.caesium.impl.ImmutableClusteredJob;
import com.atlassian.scheduler.caesium.spi.ClusteredJob;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronSyntaxException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build70010
extends AbstractImmediateUpgradeTask {
    static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build70010.class);
    private static final String TRIGGERS = "JQRTZTriggers";
    private static final String SIMPLE_TRIGGERS = "JQRTZSimpleTriggers";
    private static final String CRON_TRIGGERS = "JQRTZCronTriggers";
    private static final String JOB_NAME = "jobName";
    private static final String TRIGGER_NAME = "triggerName";
    private static final String NEXT_FIRE_TIME = "nextFireTime";
    private static final String TRIGGER_TYPE = "triggerType";
    private static final String START_TIME = "startTime";
    private static final String JOB_DATA = "jobData";
    private static final String REPEAT_INTERVAL = "repeatInterval";
    private static final String CRON_EXPRESSION = "cronExpression";
    private static final String TIME_ZONE_ID = "timeZoneId";
    private static final String TRIGGER_TYPE_SIMPLE = "SIMPLE";
    private static final String TRIGGER_TYPE_CRON = "CRON";
    final EntityEngine entityEngine;

    public UpgradeTask_Build70010(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "70010";
    }

    @Override
    public String getShortDescription() {
        return "Migrate atlassian-scheduler data from Quartz to Caesium.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        new Upgrader().run();
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    class Upgrader {
        private final Set<String> existingClusteredJobIds = this.getClusteredJobIds();

        Upgrader() {
        }

        void run() {
            LOG.debug("existingClusteredJobIds: {}", this.existingClusteredJobIds);
            this.migrateSimpleTriggers();
            this.migrateCronTriggers();
        }

        private Set<String> getClusteredJobIds() {
            List jobIds = Select.distinctString("jobId").from(Entity.CLUSTERED_JOB).runWith(UpgradeTask_Build70010.this.entityEngine).asList();
            return ImmutableSet.copyOf(jobIds);
        }

        private void migrateSimpleTriggers() {
            LOG.debug("migrateSimpleTriggers");
            List<GenericValue> triggers = this.getTriggers(UpgradeTask_Build70010.TRIGGER_TYPE_SIMPLE);
            HashMap simpleTriggers = Maps.newHashMapWithExpectedSize((int)triggers.size());
            Select.columns(UpgradeTask_Build70010.TRIGGER_NAME, UpgradeTask_Build70010.REPEAT_INTERVAL).from(UpgradeTask_Build70010.SIMPLE_TRIGGERS).runWith(UpgradeTask_Build70010.this.entityEngine).visitWith(gv -> simpleTriggers.put(gv.getString(UpgradeTask_Build70010.TRIGGER_NAME), gv.getLong(UpgradeTask_Build70010.REPEAT_INTERVAL)));
            for (GenericValue trigger : triggers) {
                this.migrateSimpleTrigger(trigger, (Long)simpleTriggers.get(trigger.getString(UpgradeTask_Build70010.TRIGGER_NAME)));
            }
        }

        private void migrateSimpleTrigger(GenericValue trigger, Long repeatInterval) {
            String jobId = trigger.getString(UpgradeTask_Build70010.TRIGGER_NAME);
            LOG.debug("migrateSimpleTrigger: {}", (Object)jobId);
            Date firstRunTime = this.toDate(trigger.getLong(UpgradeTask_Build70010.START_TIME));
            Date nextRunTime = this.toDate(trigger.getLong(UpgradeTask_Build70010.NEXT_FIRE_TIME));
            long intervalInMillis = repeatInterval != null ? repeatInterval : 0L;
            Schedule schedule = Schedule.forInterval((long)intervalInMillis, (Date)firstRunTime);
            this.createClusteredJob(trigger, jobId, nextRunTime, schedule);
        }

        private void migrateCronTriggers() {
            LOG.debug("migrateCronTriggers");
            List<GenericValue> triggers = this.getTriggers(UpgradeTask_Build70010.TRIGGER_TYPE_CRON);
            HashMap cronTriggers = Maps.newHashMapWithExpectedSize((int)triggers.size());
            Select.columns(UpgradeTask_Build70010.TRIGGER_NAME, UpgradeTask_Build70010.CRON_EXPRESSION, UpgradeTask_Build70010.TIME_ZONE_ID).from(UpgradeTask_Build70010.CRON_TRIGGERS).runWith(UpgradeTask_Build70010.this.entityEngine).visitWith(gv -> cronTriggers.put(gv.getString(UpgradeTask_Build70010.TRIGGER_NAME), gv));
            for (GenericValue trigger : triggers) {
                this.migrateCronTrigger(trigger, (GenericValue)cronTriggers.get(trigger.getString(UpgradeTask_Build70010.TRIGGER_NAME)));
            }
        }

        private void migrateCronTrigger(GenericValue trigger, GenericValue cronTrigger) {
            String jobId = trigger.getString(UpgradeTask_Build70010.TRIGGER_NAME);
            LOG.debug("migrateCronTrigger: {}", (Object)jobId);
            Date nextRunTime = this.toDate(trigger.getLong(UpgradeTask_Build70010.NEXT_FIRE_TIME));
            String cronExpression = this.repairCronExpression(jobId, cronTrigger.getString(UpgradeTask_Build70010.CRON_EXPRESSION));
            String timeZoneId = cronTrigger.getString(UpgradeTask_Build70010.TIME_ZONE_ID);
            TimeZone timeZone = timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null;
            Schedule schedule = Schedule.forCronExpression((String)cronExpression, (TimeZone)timeZone);
            this.createClusteredJob(trigger, jobId, nextRunTime, schedule);
        }

        private void createClusteredJob(GenericValue trigger, String jobId, Date nextRunTime, Schedule schedule) {
            ImmutableClusteredJob clusteredJob = ImmutableClusteredJob.builder().jobId(JobId.of((String)jobId)).jobRunnerKey(JobRunnerKey.of((String)trigger.getString(UpgradeTask_Build70010.JOB_NAME))).nextRunTime(nextRunTime).schedule(schedule).parameters((byte[])trigger.get(UpgradeTask_Build70010.JOB_DATA)).build();
            this.createClusteredJob((ClusteredJob)clusteredJob);
        }

        private void createClusteredJob(ClusteredJob clusteredJob) {
            this.deleteExistingJob(clusteredJob.getJobId().toString());
            UpgradeTask_Build70010.this.entityEngine.createValue(Entity.CLUSTERED_JOB, new OfBizClusteredJob(null, clusteredJob));
        }

        private void deleteExistingJob(String jobId) {
            if (this.existingClusteredJobIds.contains(jobId)) {
                Delete.from(Entity.CLUSTERED_JOB).whereEqual("jobId", jobId).execute(UpgradeTask_Build70010.this.entityEngine);
            }
        }

        private List<GenericValue> getTriggers(String triggerType) {
            return Select.columns(UpgradeTask_Build70010.JOB_NAME, UpgradeTask_Build70010.TRIGGER_NAME, UpgradeTask_Build70010.NEXT_FIRE_TIME, UpgradeTask_Build70010.START_TIME, UpgradeTask_Build70010.JOB_DATA).from(UpgradeTask_Build70010.TRIGGERS).whereEqual(UpgradeTask_Build70010.TRIGGER_TYPE, triggerType).runWith(UpgradeTask_Build70010.this.entityEngine).asList();
        }

        @Nullable
        private Date toDate(@Nullable Long millis) {
            return millis != null ? new Date(millis) : null;
        }

        private String repairCronExpression(String jobId, String cronExpression) {
            CronExpressionFixer.Result result = CronExpressionFixer.repairCronExpression(cronExpression);
            String repaired = result.getNewCronExpression().orElse(null);
            if (repaired != null) {
                LOG.warn("Repairing malformed cron expression for scheduled job '{}': '{}' => '{}'", new Object[]{jobId, cronExpression, repaired});
                return repaired;
            }
            return result.getCronSyntaxException().map(cse -> this.handleFailedRepair(jobId, cronExpression, (CronSyntaxException)((Object)cse))).orElse(cronExpression);
        }

        private String handleFailedRepair(String jobId, String cronExpression, CronSyntaxException cse) {
            if (jobId.startsWith(DefaultSubscriptionManager.class.getName())) {
                LOG.warn("Reverting filter subscription '{}' to the default schedule: '{}' => '{}': {}", new Object[]{jobId, cronExpression, "0 0 1 ? * *", cse.toString()});
                return "0 0 1 ? * *";
            }
            LOG.error("Scheduled job '{}' has an invalid cron expression '{}'; it will never be run", new Object[]{jobId, cronExpression, cse});
            return cronExpression;
        }
    }
}

