/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build64001
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build64001.class);
    private final OfBizDelegator ofBizDelegator;
    private final IssueIndexManager issueIndexManager;

    public UpgradeTask_Build64001(OfBizDelegator ofBizDelegator, IssueIndexManager issueIndexManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueIndexManager = issueIndexManager;
    }

    @Override
    public String getBuildNumber() {
        return "64001";
    }

    @Override
    public String getShortDescription() {
        return "JRA-34394: Fixing incorrect watch count for cloned issues";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (setupMode) {
            return;
        }
        DateTime startedAt = new DateTime();
        Map<Long, Long> watchesByIssueId = this.findWatchesByIssueId();
        List<BrokenIssue> brokenIssues = this.findBrokenIssues(watchesByIssueId);
        this.fixBrokenIssues(brokenIssues);
        if (!brokenIssues.isEmpty()) {
            this.getReindexRequestService().requestReindex(ReindexRequestType.DELAYED, EnumSet.of(AffectedIndex.ISSUE), EnumSet.noneOf(SharedEntityType.class));
        }
        log.info(String.format("Upgrade task took %d seconds to fix %d records", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds(), brokenIssues.size()));
    }

    private Map<Long, Long> findWatchesByIssueId() {
        return Select.columns("id", "watches").from("Issue").runWith(this.ofBizDelegator).consumeWith(new EntityListConsumer<GenericValue, Map<Long, Long>>(){
            final Map<Long, Long> result = new HashMap<Long, Long>();

            @Override
            public void consume(GenericValue entity) {
                this.result.put(entity.getLong("id"), entity.getLong("watches"));
            }

            @Override
            public Map<Long, Long> result() {
                return this.result;
            }
        });
    }

    private List<BrokenIssue> findBrokenIssues(final Map<Long, Long> watchesByIssueId) {
        return Select.columns("sinkNodeId", "count").from("UserAssociationCount").whereEqual("sinkNodeEntity", "Issue").whereEqual("associationType", "WatchIssue").runWith(this.ofBizDelegator).consumeWith(new EntityListConsumer<GenericValue, List<BrokenIssue>>(){
            final List<BrokenIssue> result = new LinkedList<BrokenIssue>();
            final Set<Long> issuesWithoutWatchers = new HashSet(watchesByIssueId.keySet());

            @Override
            public void consume(GenericValue entity) {
                Long issueId = entity.getLong("sinkNodeId");
                if (issueId != null) {
                    Long correctWatches = entity.getLong("count");
                    Long currentWatches = (Long)watchesByIssueId.get(issueId);
                    this.issuesWithoutWatchers.remove(issueId);
                    if (currentWatches == null || !currentWatches.equals(correctWatches)) {
                        this.result.add(new BrokenIssue(issueId, correctWatches));
                    }
                }
            }

            @Override
            public List<BrokenIssue> result() {
                for (Long issueId : this.issuesWithoutWatchers) {
                    Long currentWatches = (Long)watchesByIssueId.get(issueId);
                    if (currentWatches != null && currentWatches.equals(0L)) continue;
                    this.result.add(new BrokenIssue(issueId, 0L));
                }
                return this.result;
            }
        });
    }

    private void fixBrokenIssues(List<BrokenIssue> brokenIssues) throws GenericEntityException, IndexException {
        for (BrokenIssue brokenIssue : brokenIssues) {
            GenericValue issue = this.ofBizDelegator.findById("Issue", Long.valueOf(brokenIssue.issueId));
            if (issue == null) continue;
            issue.set("watches", (Object)brokenIssue.correctWatches);
            issue.store();
            this.issueIndexManager.reIndex(issue);
        }
    }

    private static final class BrokenIssue {
        public final long issueId;
        public final long correctWatches;

        private BrokenIssue(long issueId, long correctWatches) {
            this.issueId = issueId;
            this.correctWatches = correctWatches;
        }
    }
}

