/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build634
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build634.class);
    private final CustomFieldManager customFieldManager;

    public UpgradeTask_Build634(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String getBuildNumber() {
        return "634";
    }

    @Override
    public String getShortDescription() {
        return "Converting Custom field values for Select and MultiSelect types to store the id of the option rather than the value -  cleanup.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<CustomField> customFieldList = this.getCustomFields();
        try (Connection connection = this.getDatabaseConnection();){
            connection.setAutoCommit(false);
            for (CustomField customField : customFieldList) {
                this.processCustomField(connection, customField);
            }
        }
    }

    private void processCustomField(Connection connection, CustomField customField) throws GenericEntityException, SQLException {
        String sql = "update " + this.convertToSchemaTableName("customfieldvalue") + " set numbervalue = null where customfield = " + customField.getIdAsLong();
        Statement stmt = connection.createStatement();
        stmt.execute(sql);
        stmt.close();
        connection.commit();
    }

    private List<CustomField> getCustomFields() {
        ArrayList<CustomField> selectCustomFields = new ArrayList<CustomField>();
        List customFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFields) {
            CustomFieldType type = customField.getCustomFieldType();
            if (!(type instanceof SelectCFType) && !(type instanceof MultiSelectCFType)) continue;
            selectCustomFields.add(customField);
        }
        return selectCustomFields;
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "633";
    }
}

