/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6123
extends LegacyImmediateUpgradeTask {
    public static final int ALL_UNASSIGNED_ISSUE_TYPES = 0;
    private final OfBizDelegator ofBizDelegator;
    private final EntityEngine entityEngine;
    private final WorkflowDescriptorStore descriptorStore;
    private final WorkflowSchemeManager schemeManager;

    public UpgradeTask_Build6123(OfBizDelegator ofBizDelegator, WorkflowDescriptorStore descriptorStore, EntityEngine entityEngine, WorkflowSchemeManager schemeManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.descriptorStore = descriptorStore;
        this.entityEngine = entityEngine;
        this.schemeManager = schemeManager;
    }

    @Override
    public String getBuildNumber() {
        return "6123";
    }

    @Override
    public String getShortDescription() {
        return "Migrate the old default workflow to a new scheme/workflow";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        String classicName = this.createClassicWorkflow();
        long classicSchemeId = this.createClassicWorkflowScheme();
        this.associateWorkflowWithScheme(classicName, classicSchemeId);
        this.associateSchemeWithProjects(classicSchemeId);
        this.associateIssueTypesWithScheme(classicName, WorkflowSchemeStatus.DRAFT);
        this.associateIssueTypesWithScheme(classicName, WorkflowSchemeStatus.LIVE);
        if (this.schemeManager instanceof AbstractSchemeManager) {
            ((AbstractSchemeManager)this.schemeManager).onClearCache(ClearCacheEvent.INSTANCE);
        }
    }

    private void associateIssueTypesWithScheme(String classicWorkflowName, WorkflowSchemeStatus status) {
        Update.WhereContext updateQuery = Update.into(status.schemeEntityTableName()).set("workflow", classicWorkflowName).whereEqual("workflow", "jira");
        this.entityEngine.execute(updateQuery);
        List<GenericValue> allWorkflowIssueTypeMappingEntries = this.entityEngine.run(Select.columns("scheme", "issuetype").from(status.schemeEntityTableName())).asList();
        HashMultimap workflowIssueTypeMappings = HashMultimap.create();
        this.setDefaultIssueTypeMappingToClassicWorkflow(classicWorkflowName, allWorkflowIssueTypeMappingEntries, (SetMultimap<Long, Long>)workflowIssueTypeMappings, status.schemeEntityTableName());
        this.setDefaultIssueTypeMappingForUnmappedSchemes(classicWorkflowName, (SetMultimap<Long, Long>)workflowIssueTypeMappings, status);
    }

    private void setDefaultIssueTypeMappingForUnmappedSchemes(String classicWorkflowName, SetMultimap<Long, Long> workflowIssueTypeMappings, WorkflowSchemeStatus issueTypeMappingTable) {
        Set allMappedSchemes = workflowIssueTypeMappings.keySet();
        for (GenericValue scheme : this.entityEngine.run(Select.columns("id").from(issueTypeMappingTable.schemeTableName())).asList()) {
            Long schemeId = scheme.getLong("id");
            if (allMappedSchemes.contains(schemeId)) continue;
            this.ofBizDelegator.createValue(issueTypeMappingTable.schemeEntityTableName(), (Map)ImmutableMap.of((Object)"scheme", (Object)schemeId, (Object)"workflow", (Object)classicWorkflowName, (Object)"issuetype", (Object)0L));
        }
    }

    private void setDefaultIssueTypeMappingToClassicWorkflow(String classicWorkflowName, List<GenericValue> allWorkflowIssueTypeMappingEntries, SetMultimap<Long, Long> issueTypeMappings, String issueTypeMappingTableName) {
        for (GenericValue genericValue : allWorkflowIssueTypeMappingEntries) {
            Long schemeId = genericValue.getLong("scheme");
            Long issueType = Long.parseLong(genericValue.getString("issuetype"));
            issueTypeMappings.put((Object)schemeId, (Object)issueType);
        }
        for (Map.Entry entry : issueTypeMappings.asMap().entrySet()) {
            if (((Collection)entry.getValue()).contains(0L)) continue;
            this.ofBizDelegator.createValue(issueTypeMappingTableName, (Map)ImmutableMap.of((Object)"scheme", entry.getKey(), (Object)"workflow", (Object)classicWorkflowName, (Object)"issuetype", (Object)0L));
        }
    }

    private String createClassicWorkflow() throws FactoryException, IOException {
        WorkflowDescriptor descriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)this.defaultClassicXml());
        String workflowName = this.uniqueWorkflowName();
        descriptor.getMetaAttributes().put("jira.description", this.workflowDescription());
        this.descriptorStore.saveWorkflow(workflowName, descriptor, false);
        Long layoutEntryKey = this.ofBizDelegator.createValue("OSPropertyEntry", (Map)ImmutableMap.of((Object)"entityName", (Object)"com.atlassian.jira.plugins.jira-workflow-designer", (Object)"entityId", (Object)1, (Object)"propertyKey", (Object)UpgradeTask_Build6123.layoutKey(workflowName), (Object)"type", (Object)6)).getLong("id");
        this.ofBizDelegator.createValue("OSPropertyText", (Map)ImmutableMap.of((Object)"id", (Object)layoutEntryKey, (Object)"value", (Object)this.defaultLayoutJson()));
        return workflowName;
    }

    private long createClassicWorkflowScheme() {
        ImmutableMap newSchemeValue = ImmutableMap.of((Object)"name", (Object)this.uniqueSchemeName(), (Object)"description", (Object)this.schemeDescription());
        return (Long)this.ofBizDelegator.createValue("WorkflowScheme", (Map)newSchemeValue).get("id");
    }

    private void associateWorkflowWithScheme(String classicName, long classicSchemeId) {
        this.ofBizDelegator.createValue("WorkflowSchemeEntity", (Map)ImmutableMap.of((Object)"scheme", (Object)classicSchemeId, (Object)"workflow", (Object)classicName, (Object)"issuetype", (Object)0));
    }

    private void associateSchemeWithProjects(long classicSchemeId) throws GenericEntityException {
        List<GenericValue> allProjects = this.entityEngine.run(Select.columns("id").from("Project")).asList();
        List<GenericValue> allProjectsWithSchemes = this.entityEngine.run(Select.columns("sourceNodeId").from("NodeAssociation").whereEqual("associationType", "ProjectScheme").andEqual("sinkNodeEntity", "WorkflowScheme")).asList();
        HashSet withoutSchemes = Sets.newHashSet();
        for (GenericValue project : allProjects) {
            withoutSchemes.add(project.getLong("id"));
        }
        for (GenericValue project : allProjectsWithSchemes) {
            withoutSchemes.remove(project.getLong("sourceNodeId"));
        }
        Iterator iterator = withoutSchemes.iterator();
        while (iterator.hasNext()) {
            long projectId = (Long)iterator.next();
            GenericValue association = this.ofBizDelegator.makeValue("NodeAssociation");
            association.setFields((Map)ImmutableMap.of((Object)"associationType", (Object)"ProjectScheme", (Object)"sourceNodeId", (Object)projectId, (Object)"sourceNodeEntity", (Object)"Project", (Object)"sinkNodeId", (Object)classicSchemeId, (Object)"sinkNodeEntity", (Object)"WorkflowScheme"));
            association.create();
        }
    }

    private String uniqueWorkflowName() {
        String name = this.i18n("admin.workflows.store.classic.name");
        List<String> workflowNames = this.entityEngine.run(Select.stringColumn("name").from("Workflow")).asList();
        return this.createUniqueName(workflowNames, name);
    }

    private String uniqueSchemeName() {
        String name = this.i18n("admin.workflowschemes.store.classic.name");
        List<String> schemeNames = this.entityEngine.run(Select.stringColumn("name").from("WorkflowScheme")).asList();
        return this.createUniqueName(schemeNames, name);
    }

    private String createUniqueName(Collection<String> names, String prefix) {
        int suffix = 0;
        String systemSuffix = " (" + this.i18n("admin.workflows.readonly.system") + ")";
        String newName = prefix;
        HashSet<String> potentialCollisions = new HashSet<String>();
        for (String schemeName : names) {
            if (!schemeName.startsWith(prefix)) continue;
            potentialCollisions.add(schemeName);
        }
        if (potentialCollisions.contains(newName)) {
            prefix = newName = newName + systemSuffix;
        }
        while (potentialCollisions.contains(newName)) {
            newName = prefix + " " + ++suffix;
        }
        return newName;
    }

    private String workflowDescription() {
        return this.i18n("admin.workflows.store.classic.description");
    }

    private String schemeDescription() {
        return this.i18n("admin.workflowschemes.store.classic.name");
    }

    private String i18n(String key) {
        return new I18nBean(Locale.getDefault()).getText(key);
    }

    private static String layoutKey(String workflowName) {
        return "jira.workflow.layout:" + DigestUtils.md5Hex((String)workflowName);
    }

    private String defaultClassicXml() throws IOException {
        return this.wholeFile("system-classic-workflow.xml");
    }

    private String defaultLayoutJson() throws IOException {
        return this.wholeFile("system-classic-workflow-layout.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String wholeFile(String filename) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(filename);
        try {
            String string = IOUtils.toString((InputStream)stream, (String)"utf-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6122";
    }

    private static enum WorkflowSchemeStatus {
        DRAFT{

            @Override
            String schemeTableName() {
                return "DraftWorkflowScheme";
            }

            @Override
            String schemeEntityTableName() {
                return "DraftWorkflowSchemeEntity";
            }
        }
        ,
        LIVE{

            @Override
            String schemeTableName() {
                return "WorkflowScheme";
            }

            @Override
            String schemeEntityTableName() {
                return "WorkflowSchemeEntity";
            }
        };


        abstract String schemeTableName();

        abstract String schemeEntityTableName();
    }
}

