/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6083
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6083.class);
    private final AvatarManager avatarManager;
    static final String AVATAR_ENTITY = "Avatar";
    static final String SYSTEM_AVATAR_FIELD = "systemAvatar";
    static final Integer IS_SYSTEM = 1;
    static final Integer NOT_SYSTEM = 0;
    private static final List<String> demoteFromSystemProjectAvatars = Lists.newArrayList((Object[])new String[]{"codegeist.png", "jm_black.png", "jm_brown.png", "jm_orange.png", "jm_red.png", "jm_white.png", "jm_yellow.png", "monster.png"});
    private static final List<String> newSystemProjectAvatars = Lists.newArrayList((Object[])new String[]{"cloud.png", "config.png", "disc.png", "finance.png", "hand.png", "new_monster.png", "power.png", "refresh.png", "servicedesk.png", "settings.png", "storm.png", "travel.png"});

    public UpgradeTask_Build6083(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    @Override
    public String getBuildNumber() {
        return "6083";
    }

    @Override
    public String getShortDescription() {
        return "Adding a few new system project avatars for user selection.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        IconType iconType = IconType.PROJECT_ICON_TYPE;
        List existingSystemProjectAvatars = this.avatarManager.getAllSystemAvatars(iconType);
        ArrayList<String> avatarsToCreate = new ArrayList<String>(newSystemProjectAvatars);
        for (Avatar avatar : existingSystemProjectAvatars) {
            if (!avatarsToCreate.contains(avatar.getFileName())) continue;
            avatarsToCreate.remove(avatar.getFileName());
        }
        for (String filename : avatarsToCreate) {
            this.createAvatar(filename);
        }
    }

    private void setSystemDefaultForAvatar(Avatar avatar, boolean isSystemAvatar) {
        try {
            log.info(String.format("Changing '%s' system avatar status to " + isSystemAvatar, avatar.getFileName()));
            GenericValue gv = UpgradeTask_Build6083.getOfBizDelegator().findById(AVATAR_ENTITY, avatar.getId());
            gv.set(SYSTEM_AVATAR_FIELD, (Object)(isSystemAvatar ? IS_SYSTEM : NOT_SYSTEM));
            gv.store();
        }
        catch (GenericEntityException e) {
            log.error(String.format("Error updating '%s' system avatar status", avatar.getFileName()), (Throwable)e);
        }
    }

    private Avatar createAvatar(String fileName) {
        log.info("Creating system project avatar " + fileName);
        return this.avatarManager.create((Avatar)AvatarImpl.createSystemAvatar(fileName, "image/png", IconType.PROJECT_ICON_TYPE));
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6081";
    }
}

