/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bean.export.AutoExport;
import com.atlassian.jira.bean.export.AutoExportImpl;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.BuildVersionRegistry;
import com.atlassian.jira.upgrade.DelayedUpgradeJobRunner;
import com.atlassian.jira.upgrade.UpgradeConstraints;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.upgrade.UpgradeHistoryItemImpl;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeManagerParams;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.upgrade.util.BuildNumberDao;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.DowngradeUtilsImpl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.RunDetails;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeManagerImpl
implements UpgradeManager,
Startable {
    private static final Logger log = Logger.getLogger(UpgradeManagerImpl.class);
    private static final String UPGRADES_XML = "upgrades.xml";
    private static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\d+$");
    private static final String ENTITY_UPGRADE_VERSION_HISTORY = "UpgradeVersionHistory";
    private static final String ENTITY_UPGRADE_HISTORY = "UpgradeHistory";
    private static final String FIELD_TARGETBUILD = "targetbuild";
    private static final String FIELD_TIMEPERFORMED = "timeperformed";
    private static final String FIELD_TARGETVERSION = "targetversion";
    private static final String FIELD_UPGRADECLASS = "upgradeclass";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_DOWNGRADE_TASK_REQUIRED = "downgradetaskrequired";
    private static final String STATUS_PENDING = "pending";
    private static final String STATUS_COMPLETE = "complete";
    private static final String REINDEX_ALLOWED_PROPERTY = "upgrade.reindex.allowed";
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)DelayedUpgradeJobRunner.class.getName());
    public static final JobId JOB_ID = JobId.of((String)DelayedUpgradeJobRunner.class.getName());
    private final ApplicationProperties applicationProperties;
    private final JiraLicenseService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper.BeanFactory i18HelperFactory;
    private final BuildVersionRegistry buildVersionRegistry;
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;
    private final SchedulerHistoryService schedulerHistoryService;
    private final IndexLifecycleManager indexManager;
    private final OfBizDelegator ofBizDelegator;
    private final ReindexMessageManager reindexMessageManager;
    private final ReindexRequestManager reindexRequestManager;
    private final EntityEngine entityEngine;
    private final ClusterLockService clusterLockService;
    private final BuildVersionLicenseCheck licenseCheck;
    private final UpgradeConstraints upgradeConstraints;
    private final BuildNumberDao buildNumberDao;
    private volatile SortedMap<Integer, UpgradeTask> allUpgrades;
    private volatile SortedMap<Integer, UpgradeTask> setupUpgrades;
    private final String upgradeTaskFileName;
    private volatile Map<String, GenericValue> upgradeHistoryMap;
    private volatile String exportFilePath;

    @Inject
    public UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, IndexLifecycleManager indexManager, ReindexMessageManager reindexMessageManager, ReindexRequestManager reindexRequestManager, SchedulerService schedulerService, SchedulerHistoryService schedulerHistoryService, EntityEngine entityEngine, ClusterLockService clusterLockService, BuildVersionLicenseCheck licenseCheck, UpgradeConstraints upgradeContstraints) {
        this(jiraLicenseService, buildUtilsInfo, i18HelperFactory, applicationProperties, buildVersionRegistry, eventPublisher, ofBizDelegator, indexManager, UPGRADES_XML, reindexMessageManager, reindexRequestManager, schedulerService, schedulerHistoryService, entityEngine, clusterLockService, licenseCheck, upgradeContstraints);
    }

    @VisibleForTesting
    UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, IndexLifecycleManager indexManager, String upgradeTaskFileName, ReindexMessageManager reindexMessageManager, ReindexRequestManager reindexRequestManager, SchedulerService schedulerService, SchedulerHistoryService schedulerHistoryService, EntityEngine entityEngine, ClusterLockService clusterLockService, BuildVersionLicenseCheck licenseCheck, UpgradeConstraints upgradeConstraints) {
        this.eventPublisher = eventPublisher;
        this.upgradeConstraints = upgradeConstraints;
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.i18HelperFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18HelperFactory", (Object)i18HelperFactory);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.buildVersionRegistry = (BuildVersionRegistry)Assertions.notNull((String)"buildVersionRegistry", (Object)buildVersionRegistry);
        this.upgradeTaskFileName = upgradeTaskFileName;
        this.ofBizDelegator = ofBizDelegator;
        this.indexManager = indexManager;
        this.reindexMessageManager = reindexMessageManager;
        this.reindexRequestManager = reindexRequestManager;
        this.schedulerService = schedulerService;
        this.schedulerHistoryService = schedulerHistoryService;
        this.entityEngine = entityEngine;
        this.clusterLockService = clusterLockService;
        this.licenseCheck = licenseCheck;
        this.buildNumberDao = new BuildNumberDao(new DowngradeUtilsImpl(), applicationProperties);
    }

    @VisibleForTesting
    UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, IndexLifecycleManager indexManager, Iterable<? extends UpgradeTask> upgradeTasks, Iterable<? extends UpgradeTask> setupUpgradeTasks, ReindexMessageManager reindexMessageManager, ReindexRequestManager reindexRequestManager, SchedulerService schedulerService, SchedulerHistoryService schedulerHistoryService, EntityEngine entityEngine, ClusterLockService clusterLockService, BuildVersionLicenseCheck licenseCheck, UpgradeConstraints upgradeConstraints) {
        this(jiraLicenseService, buildUtilsInfo, i18HelperFactory, applicationProperties, buildVersionRegistry, eventPublisher, ofBizDelegator, indexManager, null, reindexMessageManager, reindexRequestManager, schedulerService, schedulerHistoryService, entityEngine, clusterLockService, licenseCheck, upgradeConstraints);
        this.allUpgrades = new TreeMap<Integer, UpgradeTask>();
        this.setupUpgrades = new TreeMap<Integer, UpgradeTask>();
        for (UpgradeTask upgradeTask : (Iterable)Assertions.notNull((String)"upgradeTasks", upgradeTasks)) {
            this.allUpgrades.put(UpgradeManagerImpl.getBuildNumberOrError(upgradeTask), upgradeTask);
        }
        for (UpgradeTask upgradeTask : (Iterable)Assertions.notNull((String)"setupUpgradeTasks", setupUpgradeTasks)) {
            this.setupUpgrades.put(UpgradeManagerImpl.getBuildNumberOrError(upgradeTask), upgradeTask);
        }
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new DelayedUpgradeJobRunner(this.entityEngine, this.indexManager, this.clusterLockService, this.applicationProperties, this.reindexRequestManager, Integer.toString(this.upgradeConstraints.getTargetDatabaseBuildNumber())));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.upgradeHistoryMap = null;
    }

    private SortedSet<Integer> getAllRelevantUpgradeBuildNumbers() {
        TreeSet<Integer> numbers = new TreeSet<Integer>();
        Upgrades standardUpgrades = this.getRelevantUpgradesFromList(this.allUpgrades);
        this.addUpgradeNumbersFromMap(numbers, standardUpgrades);
        return numbers;
    }

    private void addUpgradeNumbersFromMap(SortedSet<Integer> numbers, Upgrades upgradeMap) {
        for (Integer buildNumber : upgradeMap.unAppliedUpgrades.keySet()) {
            numbers.add(buildNumber);
        }
    }

    private void addAllUpgradesInResourceFile(Map<Integer, UpgradeTask> upgradeSet, Map<Integer, UpgradeTask> setupSet, String fileName) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)fileName, this.getClass());
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("upgrade");
            while (actions.hasMoreElements()) {
                UpgradeTask task;
                Integer buildNumber;
                Element action = (Element)actions.nextElement();
                String className = action.getElement("class").getTextString();
                String buildNumberString = action.getAttribute("build");
                try {
                    buildNumber = UpgradeManagerImpl.parseBuildNumber(buildNumberString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid build number '" + buildNumberString + "' for task '" + className + "' in file '" + fileName + "', must be an integer", e);
                }
                try {
                    task = (UpgradeTask)JiraUtils.loadComponent(className, this.getClass());
                }
                catch (ClassNotFoundException | RuntimeException e) {
                    throw new IllegalStateException("Failed to instantiate upgrade task: " + className, e);
                }
                if ("only".equals(action.getAttribute("setup"))) {
                    setupSet.put(buildNumber, task);
                    continue;
                }
                upgradeSet.put(buildNumber, task);
                if (!"true".equals(action.getAttribute("setup"))) continue;
                setupSet.put(buildNumber, task);
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException("Error parsing upgrade tasks file '" + fileName + "'", e);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.warn((Object)("Could not close " + fileName + " inputStream"));
        }
    }

    private boolean needUpgrade() {
        return this.upgradeConstraints.getTargetDatabaseBuildNumber() > this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    @Override
    public UpgradeManager.Status doUpgradeIfNeededAndAllowed(@Nullable String backupPath, UpgradeManagerParams upgradeManagerParams) throws IllegalXMLCharactersException {
        UpgradeManager.Status status;
        if (this.jiraLicenseService.isLicenseSet()) {
            LicenseCheck.Result result = this.licenseCheck.evaluate();
            if (!result.isPass()) {
                String failureMessage = result.getFailureMessage();
                log.info((Object)failureMessage);
                log.info((Object)"Cannot proceed with the upgrade.");
                return new UpgradeManager.Status(failureMessage);
            }
            UpgradeManager.Status validationStatus = this.deriveStatus(this.jiraLicenseService.validate(this.i18HelperFactory.getInstance(Locale.ENGLISH)));
            if (!validationStatus.successful()) {
                log.error((Object)"The current licenses are incompatible with this installation of JIRA.");
                return validationStatus;
            }
        }
        if ((status = this.doUpgradeIfNeeded(backupPath, upgradeManagerParams)).successful()) {
            this.eventPublisher.publish((Object)new JiraUpgradedEvent(false));
        }
        return status;
    }

    private UpgradeManager.Status deriveStatus(Iterable<JiraLicenseService.ValidationResult> validationResults) {
        ArrayList<String> errors = new ArrayList<String>();
        for (JiraLicenseService.ValidationResult result : validationResults) {
            ErrorCollection errorCollection = result.getErrorCollection();
            errors.addAll(errorCollection.getErrorMessages());
            for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
                LicenseDetails license = result.getLicenseDetails();
                if (license != null) {
                    errors.add(String.format("%s for %s : %s", entry.getKey(), license.getApplicationDescription(), entry.getValue()));
                    continue;
                }
                errors.add((String)entry.getKey() + " : " + (String)entry.getValue());
            }
        }
        return new UpgradeManager.Status(errors);
    }

    private UpgradeManager.Status doUpgradeIfNeeded(String defaultBackupPath, UpgradeManagerParams upgradeManagerParams) throws IllegalXMLCharactersException {
        if (this.needUpgrade()) {
            UpgradeManager.Status status;
            log.info((Object)("Detected that an upgrade is needed; existing data at build " + this.getDatabaseBuildNumber()));
            if ("true".equals(this.applicationProperties.getString("jira.setup"))) {
                if (!this.autoExportDisabled() && defaultBackupPath != null) {
                    log.info((Object)"Exporting the existing data..");
                    AutoExport ae = this.getAutoExport(defaultBackupPath);
                    try {
                        String exportFilePath = ae.exportData();
                        log.info((Object)("Exported pre-upgrade data to: " + exportFilePath));
                        this.setExportFilePath(exportFilePath);
                    }
                    catch (IllegalXMLCharactersException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error occurred during export before upgrade: " + e + ". If necessary, auto-export can be disabled; see " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.doc.disable.autoexport")), (Throwable)e);
                        ImmutableList errors = ImmutableList.of((Object)("Error occurred during export before upgrade: " + e.getMessage() + "\n If necessary, auto-export can be disabled; see " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.doc.disable.autoexport") + '\n' + ExceptionUtils.getStackTrace((Throwable)e)));
                        return new UpgradeManager.Status((Collection<String>)errors);
                    }
                }
            } else {
                log.debug((Object)"Not doing an auto-export.");
            }
            if (!(status = this.doUpgrade(upgradeManagerParams)).successful()) {
                return status;
            }
            if (!upgradeManagerParams.isWithoutDelay()) {
                return this.scheduleDelayedUpgrades(upgradeManagerParams);
            }
        } else {
            log.debug((Object)"Detected that no upgrade is neccessary");
            this.setVersions(this.upgradeConstraints.getTargetDatabaseBuildNumber(), upgradeManagerParams);
        }
        return UpgradeManager.Status.OK;
    }

    protected AutoExport getAutoExport(String defaultBackupPath) {
        return new AutoExportImpl(defaultBackupPath);
    }

    private boolean autoExportDisabled() {
        return !this.applicationProperties.getOption("jira.autoexport") || JiraSystemProperties.isDevMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public UpgradeManager.Status doUpgrade(UpgradeManagerParams upgradeManagerParams) {
        UpgradeManager.Status status;
        log.info((Object)"___ Performing Upgrade ____________________");
        try {
            this.getUpgrades();
            SortedSet<Integer> upgradeNumbers = this.getAllRelevantUpgradeBuildNumbers();
            Upgrades standardUpgrades = this.getRelevantUpgradesFromList(this.allUpgrades);
            status = this.runUpgradeTasks(upgradeNumbers, standardUpgrades, upgradeManagerParams);
            if (status.successful()) {
                this.logUpgradeSuccessfulMsg();
                this.setVersions(this.upgradeConstraints.getTargetDatabaseBuildNumber(), upgradeManagerParams);
            } else {
                log.error((Object)"Errors occurred during upgrade:");
                UpgradeManagerImpl.printErrors(status.getErrors());
            }
        }
        catch (Exception upgradeException) {
            status = this.handleError(upgradeException);
        }
        finally {
            this.releaseUpgrades();
            this.refreshSequencer();
        }
        return status;
    }

    private UpgradeManager.Status scheduleDelayedUpgrades(UpgradeManagerParams upgradeManagerParams) {
        int delayMins;
        if (this.applicationProperties.getOption("jira.upgrade.force.manual.schedule")) {
            return UpgradeManager.Status.OK;
        }
        String delay = this.applicationProperties.getDefaultBackedString("jira.upgrade.delay.minutes");
        try {
            delayMins = Integer.valueOf(delay);
        }
        catch (NumberFormatException e) {
            delayMins = 1;
        }
        return this.scheduleDelayedUpgrades(delayMins, upgradeManagerParams.isAllowReindex());
    }

    @Override
    public int getPendingDelayedUpgradeCount() {
        List pendingUpgrades = this.ofBizDelegator.findByAnd(ENTITY_UPGRADE_HISTORY, (Map)FieldMap.build((String)FIELD_STATUS, (Object)STATUS_PENDING));
        return pendingUpgrades.size();
    }

    @Override
    @Nonnull
    public UpgradeManager.Status scheduleDelayedUpgrades(int delayMins, boolean isAllowReindex) {
        Schedule schedule = Schedule.runOnce((Date)DateTime.now().plusMinutes(delayMins).toDate());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(schedule).withParameters((Map)ImmutableMap.of((Object)REINDEX_ALLOWED_PROPERTY, (Object)isAllowReindex));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error((Object)("Unable to schedule upgrade tasks for future execution :" + (Object)((Object)e)), (Throwable)e);
            ImmutableList errors = ImmutableList.of((Object)("Unable to schedule upgrade tasks for future execution: " + e.getMessage() + '\n' + ExceptionUtils.getStackTrace((Throwable)e)));
            return new UpgradeManager.Status((Collection<String>)errors);
        }
        return UpgradeManager.Status.OK;
    }

    @Override
    public boolean areDelayedUpgradesRunning() {
        return DelayedUpgradeJobRunner.isUpgradeRunning();
    }

    @Override
    public RunDetails getLastUpgradeResult() {
        return this.schedulerHistoryService.getLastRunForJob(JOB_ID);
    }

    private static void printErrors(Collection<String> errors) {
        for (String s : errors) {
            log.error((Object)("Upgrade Error: " + s));
        }
    }

    private UpgradeManager.Status runUpgradeTasks(Collection<Integer> upgradeNumbers, Upgrades upgradeTasks, UpgradeManagerParams upgradeManagerParams) throws Exception {
        boolean reindexSucceeded;
        boolean doReindex;
        boolean reindexRequested;
        boolean reindexingAllowed = Boolean.valueOf(JiraSystemProperties.getInstance().getProperty(REINDEX_ALLOWED_PROPERTY, "true"));
        ArrayList<String> errors = new ArrayList<String>();
        Map<String, GenericValue> upgradeHistoryMap = this.getPreviouslyRunUpgrades();
        boolean noErrors = true;
        SortedMap<Integer, UpgradeTask> tasks = upgradeTasks.getUnAppliedUpgrades();
        for (Integer number : upgradeNumbers) {
            UpgradeTask standardUpgradeTask = (UpgradeTask)tasks.get(number);
            if (this.runNow(standardUpgradeTask, upgradeManagerParams, upgradeTasks)) {
                if (!this.doUpgradeTaskSuccess(upgradeHistoryMap, standardUpgradeTask, errors, upgradeManagerParams)) {
                    noErrors = false;
                    break;
                }
                if (number <= this.getDatabaseBuildNumber()) continue;
                this.buildNumberDao.setDatabaseBuildNumber(number.toString());
                continue;
            }
            if (upgradeHistoryMap.get(standardUpgradeTask.getClass().getName()) != null) continue;
            this.addToUpgradeHistory(standardUpgradeTask, STATUS_PENDING);
        }
        if ((reindexRequested = this.reindexRequestManager.isReindexRequested(EnumSet.of(ReindexRequestType.IMMEDIATE))) && !reindexingAllowed) {
            this.reindexMessageManager.pushRawMessage(null, "admin.upgrade.reindex.deferred");
        }
        boolean bl = doReindex = reindexingAllowed && noErrors && upgradeManagerParams.isAllowReindex() && reindexRequested;
        if (doReindex && !(reindexSucceeded = this.reindex())) {
            noErrors = false;
            errors.add("Reindex failed.");
        }
        if (noErrors) {
            this.buildNumberDao.insertUpgradeVersionHistory(this.ofBizDelegator, Integer.toString(this.upgradeConstraints.getTargetDatabaseBuildNumber()), this.buildUtilsInfo.getVersion());
        }
        return new UpgradeManager.Status(errors);
    }

    private boolean runNow(UpgradeTask upgradeTask, UpgradeManagerParams upgradeManagerParams, Upgrades upgradeTasks) {
        return upgradeTask.getScheduleOption() == UpgradeTask.ScheduleOption.BEFORE_JIRA_STARTED || upgradeManagerParams.isWithoutDelay() || UpgradeManagerImpl.getBuildNumberOrError(upgradeTask) < upgradeTasks.latestImmediateTaskBuildNumber;
    }

    private void setVersions(int buildNumber, UpgradeManagerParams upgradeManagerParams) {
        try {
            this.scrubUpgradeHistoryNewerThan(buildNumber);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException("Error while scrubbing upgrade history", e);
        }
        if (upgradeManagerParams.isWithoutDelay()) {
            this.buildNumberDao.setDatabaseBuildNumber(Integer.toString(buildNumber));
        }
        this.buildNumberDao.setJiraVersion(this.buildUtilsInfo.getVersion());
        this.buildNumberDao.setMinimumDowngradeVersion();
    }

    private UpgradeManager.Status handleError(Throwable e) {
        log.error((Object)("Exception thrown during upgrade: " + e.getMessage()), e);
        return new UpgradeManager.Status("Exception thrown during upgrade: " + e.getMessage() + '\n' + ExceptionUtils.getStackTrace((Throwable)e));
    }

    private void refreshSequencer() {
        this.ofBizDelegator.refreshSequencer();
    }

    private void getUpgrades() {
        if (this.setupUpgrades == null || this.allUpgrades == null) {
            this.allUpgrades = new TreeMap<Integer, UpgradeTask>();
            this.setupUpgrades = new TreeMap<Integer, UpgradeTask>();
            this.addAllUpgradesInResourceFile(this.allUpgrades, this.setupUpgrades, this.upgradeTaskFileName);
        }
    }

    private void releaseUpgrades() {
        this.setupUpgrades = null;
        this.allUpgrades = null;
    }

    private void logUpgradeSuccessfulMsg() {
        String msg = "\n\n***************************************************************\nUpgrade Succeeded! JIRA has been upgraded to build number " + this.upgradeConstraints.getTargetDatabaseBuildNumber() + '\n' + "***************************************************************\n";
        log.info((Object)msg);
    }

    private boolean doUpgradeTaskSuccess(Map<String, GenericValue> upgradeHistoryMap, UpgradeTask upgradeTask, Collection<String> errors, UpgradeManagerParams upgradeManagerParams) throws Exception {
        if (upgradeTask != null) {
            GenericValue upgradeHistoryItem = upgradeHistoryMap.get(upgradeTask.getClass().getName());
            if (upgradeHistoryItem == null || STATUS_PENDING.equals(upgradeHistoryItem.get(FIELD_STATUS))) {
                log.info((Object)("Performing Upgrade Task: " + upgradeTask.getShortDescription()));
                upgradeTask.doUpgrade(upgradeManagerParams.isSetupMode());
                if (!upgradeTask.getErrors().isEmpty()) {
                    log.error((Object)("Errors during Upgrade Task: " + upgradeTask.getShortDescription()));
                    errors.addAll(upgradeTask.getErrors());
                    return false;
                }
                try {
                    this.addToUpgradeHistory(upgradeTask, STATUS_COMPLETE);
                }
                catch (DataAccessException e) {
                    log.error((Object)("Problem adding upgrade task " + upgradeTask.getShortDescription() + " to the upgrade history"), (Throwable)e);
                    errors.add("There was a problem adding Upgrade Task " + upgradeTask.getShortDescription() + " to the Upgrade History. This means the state of the system may be out of sync with the upgrade history, which could result in missed downgrade tasks for future exports.");
                    return false;
                }
                log.info((Object)("Upgrade Task: '" + upgradeTask.getShortDescription() + "' succeeded"));
            } else {
                log.info((Object)("Not performing Upgrade Task: '" + upgradeTask.getShortDescription() + "' as it has already been run."));
            }
        }
        return true;
    }

    private Map<String, GenericValue> getPreviouslyRunUpgrades() {
        if (this.upgradeHistoryMap == null) {
            List upgradeHistoryList = this.ofBizDelegator.findAll(ENTITY_UPGRADE_HISTORY);
            this.upgradeHistoryMap = Maps.newHashMapWithExpectedSize((int)upgradeHistoryList.size());
            for (Object element : upgradeHistoryList) {
                GenericValue upgradeHist = (GenericValue)element;
                this.upgradeHistoryMap.put(upgradeHist.getString(FIELD_UPGRADECLASS), upgradeHist);
            }
        }
        return this.upgradeHistoryMap;
    }

    Upgrades getRelevantUpgradesFromList(Map<Integer, UpgradeTask> upgradeMap) {
        try {
            Upgrades upgrades = new Upgrades();
            for (Map.Entry<Integer, UpgradeTask> entry : upgradeMap.entrySet()) {
                if (!this.upgradeTaskNeedsToRun(entry.getKey())) continue;
                upgrades.add(entry.getValue());
            }
            return upgrades;
        }
        catch (Exception upgradeListRetrievalException) {
            log.error((Object)"An occurred getting the upgrades that need to be run, returning an empty set.", (Throwable)upgradeListRetrievalException);
            return new Upgrades();
        }
    }

    private int getDatabaseBuildNumber() {
        if (this.applicationProperties.getString("jira.version.patched") == null) {
            this.buildNumberDao.setDatabaseBuildNumber("0");
        }
        return UpgradeManagerImpl.parseBuildNumber(this.applicationProperties.getString("jira.version.patched"));
    }

    private void scrubUpgradeHistoryNewerThan(final int currentBuildNumber) throws GenericEntityException {
        if (0 != currentBuildNumber) {
            Predicate<GenericValue> buildNumberPredicate = new Predicate<GenericValue>(){

                public boolean apply(GenericValue input) {
                    try {
                        return Long.parseLong(input.getString(UpgradeManagerImpl.FIELD_TARGETBUILD)) > (long)currentBuildNumber;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
            ArrayList upgradeTasksToBeScrubbed = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.ofBizDelegator.findAll(ENTITY_UPGRADE_HISTORY), (Predicate)buildNumberPredicate));
            for (GenericValue upgradeTask : upgradeTasksToBeScrubbed) {
                log.info((Object)("Scrubbing upgrade history of task " + upgradeTask.getString(FIELD_UPGRADECLASS)));
                upgradeTask.remove();
            }
            ArrayList upgradeVersionsToBeScrubbed = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.ofBizDelegator.findAll(ENTITY_UPGRADE_VERSION_HISTORY), (Predicate)buildNumberPredicate));
            for (GenericValue upgradeVersion : upgradeVersionsToBeScrubbed) {
                log.info((Object)("Scrubbing upgrade history of build " + upgradeVersion.getString(FIELD_TARGETBUILD)));
                upgradeVersion.remove();
            }
        }
    }

    private boolean upgradeTaskNeedsToRun(int taskNumber) {
        return UpgradeManagerImpl.buildNumberGreaterThanCurrent(this.getDatabaseBuildNumber(), taskNumber) && this.upgradeConstraints.shouldRunTask(Integer.toString(taskNumber));
    }

    private static boolean buildNumberGreaterThanCurrent(int currentBuild, int taskBuild) {
        return currentBuild < taskBuild;
    }

    private void addToUpgradeHistory(UpgradeTask upgradeTask, String status) {
        this.ofBizDelegator.createValue(ENTITY_UPGRADE_HISTORY, (Map)new FieldMap().add(FIELD_UPGRADECLASS, (Object)upgradeTask.getClass().getName()).add(FIELD_TARGETBUILD, (Object)upgradeTask.getBuildNumber()).add(FIELD_STATUS, (Object)status).add(FIELD_DOWNGRADE_TASK_REQUIRED, (Object)DatabaseUtil.booleanToChar1(upgradeTask.isDowngradeTaskRequired())));
    }

    @VisibleForTesting
    SortedMap<Integer, UpgradeTask> getAllUpgrades() {
        return this.allUpgrades;
    }

    @VisibleForTesting
    public void addUpgrade(@Nonnull UpgradeTask task) {
        if (this.allUpgrades == null) {
            this.allUpgrades = new TreeMap<Integer, UpgradeTask>();
        }
        if (this.setupUpgrades == null) {
            this.setupUpgrades = new TreeMap<Integer, UpgradeTask>();
        }
        Integer buildNumber = UpgradeManagerImpl.getBuildNumberOrError(task);
        this.allUpgrades.put(buildNumber, task);
        this.setupUpgrades.put(buildNumber, task);
    }

    @Override
    public String getExportFilePath() {
        return this.exportFilePath;
    }

    @Override
    public List<UpgradeHistoryItem> getUpgradeHistory() {
        try {
            ArrayList<UpgradeHistoryItem> upgradeHistoryItems = new ArrayList<UpgradeHistoryItem>();
            UpgradeHistoryItem itemFromTasks = this.getUpgradeHistoryItemFromTasks();
            String previousVersion = null;
            String previousBuildNumber = null;
            if (itemFromTasks != null) {
                upgradeHistoryItems.add(itemFromTasks);
                previousVersion = itemFromTasks.getTargetVersion();
                previousBuildNumber = itemFromTasks.getTargetBuildNumber();
            }
            List upgradeTasksWithBuild = this.ofBizDelegator.findAll(ENTITY_UPGRADE_VERSION_HISTORY, CollectionBuilder.list((Object[])new String[]{"id"}));
            for (GenericValue genericValue : upgradeTasksWithBuild) {
                Timestamp timePerformed = genericValue.getTimestamp(FIELD_TIMEPERFORMED);
                String targetBuildNumber = genericValue.getString(FIELD_TARGETBUILD);
                String targetVersion = genericValue.getString(FIELD_TARGETVERSION);
                upgradeHistoryItems.add(new UpgradeHistoryItemImpl(timePerformed, targetBuildNumber, targetVersion, previousBuildNumber, previousVersion));
                previousVersion = targetVersion;
                previousBuildNumber = targetBuildNumber;
            }
            Collections.reverse(upgradeHistoryItems);
            return Collections.unmodifiableList(upgradeHistoryItems);
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    UpgradeHistoryItem getUpgradeHistoryItemFromTasks() throws GenericEntityException {
        GenericValue genericValue;
        String upgradeClassName;
        Integer buildNumber;
        List upgradeTasksWithoutBuild = this.ofBizDelegator.findByCondition("UpgradeHistoryLastClassForTargetBuild", (EntityCondition)new EntityExpr(FIELD_TARGETBUILD, EntityOperator.EQUALS, null), (Collection)CollectionBuilder.list((Object[])new String[]{FIELD_UPGRADECLASS}), Collections.emptyList());
        if (!upgradeTasksWithoutBuild.isEmpty() && (buildNumber = UpgradeManagerImpl.extractBuildNumberFromUpgradeClass(upgradeClassName = (genericValue = (GenericValue)upgradeTasksWithoutBuild.get(0)).getString(FIELD_UPGRADECLASS))) != null) {
            BuildVersionRegistry.BuildVersion targetVersion = this.buildVersionRegistry.getVersionForBuildNumber(buildNumber);
            return new UpgradeHistoryItemImpl(null, Integer.toString(targetVersion.getBuildNumberAsInteger()), targetVersion.getVersion(), Integer.toString(buildNumber), null, true);
        }
        return null;
    }

    @Override
    public boolean hasUpgradeTaskRun(Class<? extends UpgradeTask> clazz) {
        UpgradeTask task = JiraUtils.loadComponent(clazz);
        List pendingUpgrades = this.ofBizDelegator.findByAnd(ENTITY_UPGRADE_HISTORY, (Map)FieldMap.build((String)FIELD_TARGETBUILD, (Object)task.getBuildNumber()));
        if (pendingUpgrades.size() > 0) {
            return STATUS_COMPLETE.equals(((GenericValue)pendingUpgrades.get(0)).get(FIELD_STATUS));
        }
        return false;
    }

    static Integer extractBuildNumberFromUpgradeClass(String upgradeClassName) {
        Pattern pattern = BUILD_NUMBER_PATTERN;
        Matcher matcher = pattern.matcher(upgradeClassName);
        if (matcher.find()) {
            return Integer.valueOf(matcher.group(0));
        }
        return null;
    }

    private void setExportFilePath(String exportFilePath) {
        this.exportFilePath = exportFilePath;
    }

    private boolean reindex() throws Exception {
        log.debug((Object)"Reindex all data if indexing is turned on.");
        Set reindexRequests = this.reindexRequestManager.processPendingRequests(true, EnumSet.of(ReindexRequestType.IMMEDIATE), false);
        for (ReindexRequest reindexRequest : reindexRequests) {
            if (reindexRequest.getStatus() != ReindexStatus.FAILED) continue;
            return false;
        }
        return true;
    }

    private static int getBuildNumberOrError(@Nonnull UpgradeTask task) {
        String buildNumber = task.getBuildNumber();
        try {
            return UpgradeManagerImpl.parseBuildNumber(buildNumber);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Invalid build number '" + buildNumber + "' for task '" + task.getClass().getName() + "', must be an integer", e);
        }
    }

    private static int parseBuildNumber(String buildNumberString) {
        return Integer.parseInt(buildNumberString);
    }

    public class Upgrades {
        private final SortedMap<Integer, UpgradeTask> unAppliedUpgrades = new TreeMap<Integer, UpgradeTask>();
        private int latestImmediateTaskBuildNumber = 0;

        public void add(UpgradeTask upgradeTask) {
            int upgradeTaskBuildNumber = UpgradeManagerImpl.getBuildNumberOrError(upgradeTask);
            if (upgradeTask.getScheduleOption() == UpgradeTask.ScheduleOption.BEFORE_JIRA_STARTED && upgradeTaskBuildNumber > this.latestImmediateTaskBuildNumber) {
                this.latestImmediateTaskBuildNumber = upgradeTaskBuildNumber;
            }
            this.unAppliedUpgrades.put(upgradeTaskBuildNumber, upgradeTask);
        }

        public SortedMap<Integer, UpgradeTask> getUnAppliedUpgrades() {
            return this.unAppliedUpgrades;
        }
    }
}

