/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tenancy;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.plugin.predicate.PluginKeyPatternsPredicate;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginKeyPredicateLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginKeyPredicateLoader.class);
    private static final String ATLASSIAN_PLUGINS_TENANT_SMART_PATTERNS = "atlassian.plugins.tenant.smart.patterns";
    private static final String DEFAULT_FILENAME = "tenant-smart-patterns.txt";
    private final String fileName;
    private final LazyReference<PluginKeyPatternsPredicate> pluginKeyPredicateRef = new LazyReference<PluginKeyPatternsPredicate>(){

        protected PluginKeyPatternsPredicate create() {
            return new PluginKeyPatternsPredicate(PluginKeyPatternsPredicate.MatchType.MATCHES_ANY, (Collection)PluginKeyPredicateLoader.this.load());
        }
    };

    public PluginKeyPredicateLoader() {
        String fileName = JiraSystemProperties.getInstance().getProperty(ATLASSIAN_PLUGINS_TENANT_SMART_PATTERNS);
        if (fileName == null) {
            fileName = this.getRealPathForDefaultFileName();
        }
        this.fileName = fileName;
    }

    private String getRealPathForDefaultFileName() {
        return ServletContextProvider.getServletContext().getRealPath("/WEB-INF/classes/tenant-smart-patterns.txt");
    }

    @VisibleForTesting
    PluginKeyPredicateLoader(String fileName) {
        this.fileName = fileName;
    }

    private List<String> load() {
        try {
            File file = new File(this.fileName);
            Iterable tenantSmartPatterns = Iterables.filter((Iterable)FileUtils.readLines((File)file), (Predicate)new Predicate<String>(){

                public boolean apply(String line) {
                    return !line.isEmpty() && line.charAt(0) != '#';
                }
            });
            return ImmutableList.copyOf((Iterable)tenantSmartPatterns);
        }
        catch (IOException eio) {
            LOG.debug("Could not read tenant-smart pattern file '{}' (using defaults)", (Object)this.fileName);
            return ImmutableList.of();
        }
    }

    public PluginKeyPatternsPredicate getPluginKeyPatternsPredicate() {
        return (PluginKeyPatternsPredicate)this.pluginKeyPredicateRef.get();
    }
}

