/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.cache.JiraVCacheRequestContextSupplier;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentAccessorWorker;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.instrumentation.jdbc.InstantLogJdbcStatsCollector;
import com.atlassian.jira.startup.DefaultJiraLauncher;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.studio.startup.StudioStartupHooks;
import com.atlassian.jira.studio.startup.StudioStartupHooksLocator;
import com.atlassian.jira.util.MemoryPools;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LauncherContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(LauncherContextListener.class);
    private static final String PROPERTY_LOG_JDBC_ON_STARTUP = "jira.jdbc.startup.logging";
    private static final String JDBC_STARTUP_LOGGER_NAME = "jdbc.startup.log";
    private static final String SYNCHRONOUS = LauncherContextListener.class.getName() + ".SYNCHRONOUS";
    public static final String STARTUP_UNEXPECTED = "startup-unexpected";
    private static final String LOG4J = "log4j.properties";
    private static final int DEADLOCK_DETECTION_PERIOD = 5;
    private final ScheduledExecutorService deadlockDetectionService = Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory("DeadlockDetection"));
    private final StudioStartupHooks startupHooks = StudioStartupHooksLocator.getStudioStartupHooks();
    private final JohnsonProvider johnsonProvider;
    private volatile Thread bootstrap;
    private volatile JiraLauncher launcher;
    private InstantLogJdbcStatsCollector jdbcStatsCollector;

    public LauncherContextListener() {
        this.johnsonProvider = new DefaultJohnsonProvider();
    }

    public LauncherContextListener(JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
    }

    public void contextInitialized(ServletContextEvent sce) {
        if (this.bootstrap != null || this.launcher != null) {
            throw new IllegalStateException("JIRA cannot be initialized twice!");
        }
        try {
            JiraVCacheRequestContextSupplier.initStaticContext("staticStartupContext");
            this.initStartupJdbcLogging();
            this.initFastStuff();
            this.initSlowStuffInBackground();
        }
        catch (Exception e) {
            this.fatalJohnson(e);
        }
        catch (Error e) {
            log.error("Unable to start JIRA due to Java Error", (Throwable)e);
            throw e;
        }
        finally {
            JiraVCacheRequestContextSupplier.clearStaticContext();
            this.finishStartupJdbcLogging();
        }
    }

    private void initStartupJdbcLogging() {
        boolean shouldLog = JiraSystemProperties.getInstance().getBoolean(PROPERTY_LOG_JDBC_ON_STARTUP);
        if (shouldLog) {
            try {
                Class.forName("com.atlassian.instrumentation.driver.Instrumentation");
                org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)JDBC_STARTUP_LOGGER_NAME);
                this.jdbcStatsCollector = new InstantLogJdbcStatsCollector(logger);
                this.jdbcStatsCollector.register();
            }
            catch (ClassNotFoundException e) {
                log.debug("No metrics driver present - startup jdbc logging will be disabled");
            }
        }
    }

    private void finishStartupJdbcLogging() {
        if (this.jdbcStatsCollector != null) {
            this.jdbcStatsCollector.unregister();
            this.jdbcStatsCollector = null;
        }
    }

    private void initFastStuff() {
        this.configureLog4j(this.startupHooks);
        log.debug("Launching JIRA");
        this.startupHooks.beforeJiraStart();
        ComponentAccessor.initialiseWorker((ComponentAccessor.Worker)new ComponentAccessorWorker());
    }

    private void initSlowStuffInBackground() {
        if (LauncherContextListener.isSynchronousStartup()) {
            this.initSlowStuff();
        } else {
            Thread bootstrap;
            this.bootstrap = bootstrap = new Thread(this::initSlowStuff, "JIRA-Bootstrap");
            bootstrap.start();
        }
    }

    private void initSlowStuff() {
        log.debug("Startup deadlock detector launched...");
        ScheduledFuture<?> deadLockDetector = this.deadlockDetectionService.scheduleAtFixedRate(new DeadlockDetector(), 0L, 5L, TimeUnit.SECONDS);
        try {
            this.launcher = new DefaultJiraLauncher(this.johnsonProvider);
            this.launcher.start();
            this.startupHooks.afterJiraStart();
        }
        catch (Exception e) {
            this.fatalJohnson(e);
        }
        catch (Error e) {
            this.fatalJohnson(e);
            throw e;
        }
        finally {
            deadLockDetector.cancel(false);
            this.deadlockDetectionService.shutdown();
            log.debug("Startup deadlock detector finished.");
            this.initDone();
        }
        log.info("Memory Usage:\n" + MemoryPools.memoryPoolsDump(false));
    }

    private void fatalJohnson(Throwable e) {
        log.error("Unable to start JIRA.", e);
        this.johnsonProvider.getContainer().addEvent(new Event(EventType.get((String)STARTUP_UNEXPECTED), "Unexpected exception during JIRA startup. This JIRA instance will not be able to recover. Please check the logs for details", EventLevel.get((String)"fatal")));
    }

    private void initDone() {
        if (!ComponentManager.getInstance().getState().isStarted() && !this.johnsonProvider.getContainer().hasEvents()) {
            this.fatalJohnson(new IllegalStateException("Abnormal system startup detected"));
        }
        StartupPageSupport.setLaunched(true);
        this.bootstrap = null;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.interruptBootstrap();
        if (this.launcher == null) {
            throw new IllegalStateException("Context destroyed without being initialized first. JIRA launcher is confused.");
        }
        this.launcher.stop();
        this.launcher = null;
    }

    private void interruptBootstrap() {
        Thread bootstrap = this.bootstrap;
        if (bootstrap == null) {
            return;
        }
        this.bootstrap = null;
        bootstrap.interrupt();
        try {
            bootstrap.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLog4j(StudioStartupHooks startupHooks) {
        Properties properties = new Properties();
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(LOG4J);
        if (resource != null) {
            try {
                properties.load(resource);
            }
            catch (IOException e) {
                log.warn("Unable read current log4j configuration. Assuming blank configuration.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)resource);
            }
        } else {
            log.warn("Unable to find 'log4j.properties' on class path.");
        }
        Properties newConfig = startupHooks.getLog4jConfiguration(properties);
        if (newConfig != null) {
            PropertyConfigurator.configure((Properties)newConfig);
        }
    }

    private static boolean isClustered() {
        return JiraHomeStartupCheck.getInstance().isOk() && new File(JiraHomeStartupCheck.getInstance().getJiraHomeDirectory(), "cluster.properties").exists();
    }

    private static boolean isSynchronousStartup() {
        return JiraSystemProperties.getInstance().getBoolean(SYNCHRONOUS) != false || LauncherContextListener.isClustered();
    }

    private static final class DeadlockDetectedException
    extends RuntimeException {
        private DeadlockDetectedException() {
        }
    }

    private static class DeadlockDetector
    implements Runnable {
        private static final String DEAD_LOCK_DETECTOR_KB_URL = "https://confluence.atlassian.com/display/JIRAKB/Deadlock+detected+on+startup+error+in+logfile";
        private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

        private DeadlockDetector() {
        }

        @Override
        public void run() {
            long[] threadIds = this.threadMXBean.findDeadlockedThreads();
            if (threadIds != null) {
                ArrayList threadInfoStrings = Lists.newArrayList();
                for (ThreadInfo threadInfo : this.threadMXBean.getThreadInfo(threadIds, 0)) {
                    threadInfoStrings.add(StringUtils.trim((String)threadInfo.toString()));
                }
                log.error(String.format("A deadlock has been detected on JIRA startup for the following threads: %s", threadInfoStrings));
                for (ThreadInfo threadInfo : this.threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
                    log.error(DeadlockDetector.generateStackTrace(threadInfo));
                }
                log.error(String.format("Further troubleshooting information about this issue is available in the KB article at: %s", DEAD_LOCK_DETECTOR_KB_URL));
                throw new DeadlockDetectedException();
            }
        }

        private static String generateStackTrace(ThreadInfo threadInfo) {
            StackTraceElement[] stackTrace;
            StringBuilder stackTraceString = new StringBuilder();
            stackTraceString.append(StringUtils.trim((String)threadInfo.toString())).append(":\n");
            for (StackTraceElement stackTraceElement : stackTrace = threadInfo.getStackTrace()) {
                stackTraceString.append('\t').append(stackTraceElement.toString()).append('\n');
            }
            return stackTraceString.toString();
        }
    }
}

