/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.jdk.utilities.runtimeinformation.MemoryInformation;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.configurableobjects.ConfigurableObjectUtil;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationManager;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationService;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.startup.FormattedLogMsg;
import com.atlassian.jira.startup.PluginInfoProvider;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.JiraLogLocator;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.util.system.ReleaseInfo;
import com.atlassian.jira.util.system.SystemInfoUtilsImpl;
import com.atlassian.jira.util.system.patch.AppliedPatchInfo;
import com.atlassian.jira.util.system.patch.AppliedPatches;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraSystemInfo {
    private static final Logger log = LoggerFactory.getLogger(JiraSystemInfo.class);
    private static final String STRANGELY_UNKNOWN = "unknown??";
    private static final long MEGABYTE = 0x100000L;
    private static final Set<String> PATH_RELATED_KEYS = ImmutableSet.of((Object)"sun.boot.class.path", (Object)"com.ibm.oti.vm.bootstrap.library.path", (Object)"java.library.path", (Object)"java.endorsed.dirs", (Object)"java.ext.dirs", (Object)"java.class.path", (Object[])new String[0]);
    private static final Set<String> IGNORE_THESE_KEYS = ImmutableSet.builder().addAll(PATH_RELATED_KEYS).add((Object)"line.separator").add((Object)"path.separator").add((Object)"file.separator").build();
    private final FormattedLogMsg logMsg;
    private final BuildUtilsInfo buildUtilsInfo;
    private final OfBizConnectionFactory connectionFactory;
    private final JiraProperties jiraSystemProperties;

    public JiraSystemInfo(FormattedLogMsg logMsg, BuildUtilsInfo buildUtilsInfo) {
        this(logMsg, buildUtilsInfo, DefaultOfBizConnectionFactory.getInstance(), JiraSystemProperties.getInstance());
    }

    @VisibleForTesting
    JiraSystemInfo(FormattedLogMsg logMsg, BuildUtilsInfo buildUtilsInfo, OfBizConnectionFactory connectionFactory, JiraProperties properties) {
        this.logMsg = (FormattedLogMsg)Assertions.notNull((String)"logMsg", (Object)logMsg);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.connectionFactory = (OfBizConnectionFactory)Assertions.notNull((String)"connectionFactory", (Object)connectionFactory);
        this.jiraSystemProperties = (JiraProperties)Assertions.notNull((String)"properties", (Object)properties);
    }

    public void obtainBasicInfo(ServletContext context) {
        SystemInfoUtilsImpl systemInfoUtils = new SystemInfoUtilsImpl();
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo(ReleaseInfo.class);
        this.logMsg.outputHeader("Environment");
        this.logMsg.outputProperty("JIRA Build", this.buildUtilsInfo.getBuildInformation());
        this.logMsg.outputProperty("Build Date", String.valueOf(this.buildUtilsInfo.getCurrentBuildDate()));
        this.logMsg.outputProperty("JIRA Installation Type", releaseInfo.getInfo());
        if (context != null) {
            this.logMsg.outputProperty("Application Server", context.getServerInfo() + " - Servlet API " + context.getMajorVersion() + "." + context.getMinorVersion());
        }
        this.logMsg.outputProperty("Java Version", this.jiraSystemProperties.getProperty("java.version", STRANGELY_UNKNOWN) + " - " + this.jiraSystemProperties.getProperty("java.vendor", STRANGELY_UNKNOWN));
        this.logMsg.outputProperty("Current Working Directory", this.jiraSystemProperties.getProperty("user.dir", STRANGELY_UNKNOWN));
        Runtime rt = Runtime.getRuntime();
        long maxMemory = rt.maxMemory() / 0x100000L;
        long totalMemory = rt.totalMemory() / 0x100000L;
        long freeMemory = rt.freeMemory() / 0x100000L;
        long usedMemory = totalMemory - freeMemory;
        this.logMsg.outputProperty("Maximum Allowable Memory", maxMemory + "MB");
        this.logMsg.outputProperty("Total Memory", totalMemory + "MB");
        this.logMsg.outputProperty("Free Memory", freeMemory + "MB");
        this.logMsg.outputProperty("Used Memory", usedMemory + "MB");
        for (MemoryInformation memory : systemInfoUtils.getMemoryPoolInformation()) {
            this.logMsg.outputProperty("Memory Pool: " + memory.getName(), memory.toString());
        }
        this.logMsg.outputProperty("JVM Input Arguments", systemInfoUtils.getJvmInputArguments());
        Set<AppliedPatchInfo> appliedPatches = AppliedPatches.getAppliedPatches();
        if (appliedPatches.size() > 0) {
            this.logMsg.outputHeader("Applied Patches");
            for (AppliedPatchInfo appliedPatch : appliedPatches) {
                this.logMsg.outputProperty(appliedPatch.getIssueKey(), appliedPatch.getDescription());
            }
        }
        this.logMsg.outputProperty("Java Compatibility Information", "JIRA version = " + this.buildUtilsInfo.getVersion() + ", Java Version = " + this.jiraSystemProperties.getProperty("java.version", STRANGELY_UNKNOWN));
    }

    public void obtainSystemProperties() {
        Map sysProps = Maps.filterKeys((Map)this.jiraSystemProperties.getSanitisedProperties(), (Predicate)Predicates.not(IGNORE_THESE_KEYS::contains));
        this.logMsg.outputHeader("Java System Properties");
        for (Map.Entry entry : sysProps.entrySet()) {
            this.logMsg.outputProperty((String)entry.getKey(), (String)entry.getValue(), ",");
        }
    }

    public void obtainSystemPathProperties() {
        Map sysProps = this.jiraSystemProperties.getSanitisedProperties();
        this.logMsg.outputHeader("Java Class Paths");
        for (String key : PATH_RELATED_KEYS) {
            String value = (String)sysProps.get(key);
            if (value == null) continue;
            this.logMsg.outputProperty(key, value, File.pathSeparator);
            this.logMsg.add("");
        }
    }

    public void obtainUserDirectoyInfo() {
        if (JiraUtils.isSetup()) {
            CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)ComponentAccessor.getComponent(CrowdDirectoryService.class);
            this.logMsg.outputHeader("User Directories (Ordered)");
            List directories = crowdDirectoryService.findAllDirectories();
            for (Directory directory : directories) {
                this.logMsg.outputProperty(directory.getType().name(), directory.getName());
                this.logMsg.outputProperty("Implementing Class", directory.getImplementationClass(), 2);
                this.logMsg.outputProperty("Allowed Operations", StringUtils.join((Collection)directory.getAllowedOperations(), (String)","), ",", 2);
                this.logMsg.outputProperty("Encryption Type", directory.getEncryptionType(), 2);
                this.logMsg.outputProperty("Active", String.valueOf(directory.isActive()), 2);
                this.logMsg.outputProperty("Attributes", "", 2);
                Map attributes = directory.getAttributes();
                ArrayList keys = new ArrayList(attributes.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    String value = key.toLowerCase().contains("password") ? "xxxxxx" : (String)attributes.get(key);
                    this.logMsg.outputProperty(key, value, 3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obtainDatabaseConfigurationInfo() {
        this.logMsg.outputHeader("Database Configuration");
        URL entityEngineURL = ClassLoaderUtils.getResource((String)"entityengine.xml", this.getClass());
        this.logMsg.outputProperty("Loading entityengine.xml from", entityEngineURL.toString());
        DatasourceInfo datasourceInfo = this.connectionFactory.getDatasourceInfo();
        if (datasourceInfo != null) {
            this.logMsg.outputProperty("Entity model field type name", datasourceInfo.getFieldTypeName());
            this.logMsg.outputProperty("Entity model schema name", datasourceInfo.getSchemaName());
        }
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            SystemInfoUtilsImpl jiraSysInfo = new SystemInfoUtilsImpl();
            this.logMsg.outputProperty("Database Version", metaData.getDatabaseProductName() + " - " + metaData.getDatabaseProductVersion());
            this.logMsg.outputProperty("Database Driver", metaData.getDriverName() + " - " + metaData.getDriverVersion());
            this.logMsg.outputProperty("Database URL", this.maskURL(metaData.getURL()));
            this.logMsg.outputProperty(jiraSysInfo.getDbDescriptorLabel(), jiraSysInfo.getDbDescriptorValue());
        }
        catch (SQLException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            this.silentlyClose(connection);
        }
    }

    public void obtainJiraAppProperties() {
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo(ReleaseInfo.class);
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        ExtendedSystemInfoUtilsImpl extendedSystemInfoUtils = new ExtendedSystemInfoUtilsImpl(new I18nBean(Locale.ENGLISH));
        JiraLicenseService jiraLicenseService = (JiraLicenseService)ComponentAccessor.getComponentOfType(JiraLicenseService.class);
        String defaultLocal = applicationProperties.getDefaultLocale().getDisplayName();
        String externalUserManagment = applicationProperties.getOption("jira.option.user.externalmanagement") ? "ON" : "OFF";
        String partnerName = this.buildUtilsInfo.getBuildPartnerName();
        String baseUrl = applicationProperties.getDefaultBackedString("jira.baseurl");
        if (StringUtils.isBlank((String)baseUrl)) {
            baseUrl = "not set";
        }
        this.logMsg.outputHeader("Core Application Properties");
        this.logMsg.outputProperty("Version", this.buildUtilsInfo.getVersion());
        this.logMsg.outputProperty("Build #", this.buildUtilsInfo.getCurrentBuildNumber());
        this.logMsg.outputProperty("Build Date", String.valueOf(this.buildUtilsInfo.getCurrentBuildDate()));
        this.logMsg.outputProperty("Installation Type", releaseInfo.getInfo());
        if (StringUtils.isNotEmpty((String)partnerName)) {
            this.logMsg.outputProperty("Atlassian Partner", partnerName);
        }
        this.logMsg.outputProperty("Server ID", jiraLicenseService.getServerId());
        this.logMsg.outputProperty("Base URL", baseUrl);
        this.logMsg.outputProperty("Default Language", defaultLocal);
        this.logMsg.outputProperty("External User Management", externalUserManagment);
        this.logMsg.outputHeader("Application Properties");
        Map<String, String> allProperties = extendedSystemInfoUtils.getApplicationPropertiesFormatted("\n");
        for (Map.Entry<String, String> entry : allProperties.entrySet()) {
            this.logMsg.outputProperty(entry.getKey(), entry.getValue());
        }
        this.obtainLicenseInfo(jiraLicenseService);
    }

    private void obtainLicenseInfo(JiraLicenseService jiraLicenseService) {
        this.logMsg.outputHeader("License Details");
        if (!jiraLicenseService.isLicenseSet()) {
            this.logMsg.add("(no licenses set)");
            return;
        }
        for (LicenseDetails licenseDetails : jiraLicenseService.getLicenses()) {
            this.logMsg.outputProperty("Entitled To Support", String.valueOf(licenseDetails.isEntitledToSupport()));
            this.logMsg.outputProperty("Evaluation", String.valueOf(licenseDetails.isEvaluation()));
            this.logMsg.outputProperty("Description", licenseDetails.getDescription());
            this.logMsg.outputProperty("SEN", licenseDetails.getSupportEntitlementNumber());
            this.logMsg.outputProperty("Organisation", licenseDetails.getOrganisation());
            this.logMsg.outputProperty("Partner", licenseDetails.getPartnerName());
            LicensedApplications applications = licenseDetails.getLicensedApplications();
            for (ApplicationKey applicationKey : applications.getKeys()) {
                int userLimit = applications.getUserLimit(applicationKey);
                this.logMsg.outputProperty("Maximum Number Of Users for " + applicationKey, userLimit == -1 ? "Unlimited" : String.valueOf(userLimit));
            }
        }
        this.logMsg.add("");
    }

    public void obtainDatabaseStatistics() {
        OfBizDelegator delegator = ComponentAccessor.getOfBizDelegator();
        long issueCount = delegator.getCount("Issue");
        long projectCount = delegator.getCount("Project");
        long customFieldCount = delegator.getCount("CustomField");
        long workflowCount = delegator.getCount("Workflow");
        long userCount = delegator.getCount("User");
        long groupCount = delegator.getCount("Group");
        long attachmentCount = delegator.getCount("FileAttachment");
        int commentCount = this.obtainCommentCountFromIndex();
        this.logMsg.outputHeader("Database Statistics");
        this.logMsg.outputProperty("Issues", String.valueOf(issueCount));
        this.logMsg.outputProperty("Projects", String.valueOf(projectCount));
        this.logMsg.outputProperty("Custom Fields", String.valueOf(customFieldCount));
        this.logMsg.outputProperty("Workflows", String.valueOf(workflowCount));
        this.logMsg.outputProperty("Users", String.valueOf(userCount));
        this.logMsg.outputProperty("Groups", String.valueOf(groupCount));
        this.logMsg.outputProperty("Attachments", String.valueOf(attachmentCount));
        this.logMsg.outputProperty("Comments", String.valueOf(commentCount));
    }

    private int obtainCommentCountFromIndex() {
        IssueIndexManager indexManager = (IssueIndexManager)ComponentAccessor.getComponentOfType(IssueIndexManager.class);
        try {
            return indexManager.getCommentSearcher().getIndexReader().numDocs();
        }
        catch (SearchUnavailableException ignored) {
            return 0;
        }
    }

    public void obtainUpgradeHistory() {
        UpgradeManager upgradeManager = (UpgradeManager)ComponentAccessor.getComponentOfType(UpgradeManager.class);
        List<UpgradeHistoryItem> history = upgradeManager.getUpgradeHistory();
        this.logMsg.outputHeader("Upgrade History");
        if (history.isEmpty()) {
            this.logMsg.add("No upgrade information is available for this instance.", 1);
            return;
        }
        for (UpgradeHistoryItem upgradeHistoryItem : history) {
            String targetVersion = String.format("%s%s%s", upgradeHistoryItem.getTargetVersion(), "#", upgradeHistoryItem.getTargetBuildNumber());
            String originalVersion = upgradeHistoryItem.getOriginalVersion() != null ? String.format("%s%s%s", upgradeHistoryItem.getOriginalVersion(), "#", upgradeHistoryItem.getOriginalBuildNumber()) : null;
            String date = upgradeHistoryItem.getTimePerformed() != null ? String.valueOf(upgradeHistoryItem.getTimePerformed()) : "Unknown";
            this.logMsg.add(targetVersion, 1);
            this.logMsg.outputProperty("Time Performed", date, 2);
            if (originalVersion != null) {
                this.logMsg.outputProperty("Original Version", originalVersion, 2);
            }
            this.logMsg.add("");
        }
    }

    public void obtainFilePaths() {
        this.obtainFilePaths((JiraHome)ComponentAccessor.getComponent(JiraHome.class));
    }

    public void obtainFilePaths(JiraHome jiraHome) {
        String jiraLocalHomePath;
        String jiraHomePath;
        String indexPath = ComponentAccessor.getIndexPathManager().getIndexRootPath();
        String attachmentPath = ComponentAccessor.getAttachmentPathManager().getAttachmentPath();
        this.logMsg.outputHeader("File Paths");
        try {
            jiraHomePath = jiraHome.getHomePath();
        }
        catch (IllegalStateException e) {
            jiraHomePath = "";
        }
        this.logMsg.outputProperty("JIRA Home", jiraHomePath);
        try {
            jiraLocalHomePath = jiraHome.getLocalHomePath();
        }
        catch (IllegalStateException e) {
            jiraLocalHomePath = "";
        }
        this.logMsg.outputProperty("JIRA Local Home", jiraLocalHomePath);
        this.logMsg.outputProperty("Location of atlassian-jira.log", this.getLogPath(jiraHome));
        this.logMsg.outputProperty("Index Path", indexPath);
        this.logMsg.outputProperty("Attachment Path", attachmentPath);
    }

    public void obtainPlugins() {
        PluginInfoProvider pluginInfoProvider = (PluginInfoProvider)ComponentAccessor.getComponentOfType(PluginInfoProvider.class);
        this.logMsg.add(pluginInfoProvider.getUserPlugins().prettyPrint());
        this.logMsg.add(pluginInfoProvider.getSystemPlugins(false).prettyPrint());
    }

    public void obtainListeners() {
        OfBizDelegator delegator = ComponentAccessor.getOfBizDelegator();
        List listenerGVs = delegator.findAll("ListenerConfig");
        ArrayList listeners = Lists.newArrayListWithCapacity((int)listenerGVs.size());
        for (GenericValue gv : listenerGVs) {
            String name = gv.getString("name");
            if (name.startsWith("com.atlassian.jira.event,listeners")) continue;
            listeners.add(new ListenerRepresentation(gv));
        }
        this.logMsg.outputHeader("Listeners");
        this.logMsg.outputProperty("Instance Count", String.valueOf(listeners.size()));
        this.logMsg.add("");
        for (ListenerRepresentation rep : listeners) {
            this.logMsg.outputProperty(rep.name, rep.clazz);
            this.logPropertySet(rep.gv, 2);
        }
    }

    private void logPropertySet(GenericValue gv, int indentLevel) {
        PropertySet propertySet = OFBizPropertyUtils.getCachingPropertySet(gv);
        if (propertySet != null) {
            Collection properties = propertySet.getKeys();
            for (String key : properties) {
                this.logMsg.outputProperty(key, String.valueOf(propertySet.getAsActualType(key)), indentLevel);
            }
        }
    }

    public void obtainServices() {
        ServiceManager serviceManager = (ServiceManager)ComponentAccessor.getComponentOfType(ServiceManager.class);
        TreeSet services = new TreeSet(JiraService.NAME_COMPARATOR);
        services.addAll(serviceManager.getServices());
        this.logMsg.outputHeader("Services");
        this.logMsg.outputProperty("Instance Count", String.valueOf(services.size()));
        this.logMsg.add("");
        services.forEach(this::printServiceInfo);
    }

    private void printServiceInfo(JiraServiceContainer service) {
        this.logMsg.outputProperty(service.getName(), service.getServiceClass());
        this.logMsg.outputProperty("Service Schedule", service.getCronExpression(), 2);
        try {
            long lastRun = service.getLastRun();
            if (lastRun > 0L) {
                DateFormat df = DateFormat.getInstance();
                Date dt = new Date(lastRun);
                this.logMsg.outputProperty("Last Run", df.format(dt));
            }
            Map<String, String> properties = ConfigurableObjectUtil.getPropertyMap(service);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                this.logMsg.outputProperty(entry.getKey(), entry.getValue(), 2);
            }
        }
        catch (Exception e) {
            this.logMsg.outputProperty("Exception getting Service information", e.toString());
        }
    }

    public void obtainTrustedApps() {
        TrustedApplicationManager trustedAppManager = (TrustedApplicationManager)ComponentAccessor.getComponentOfType(TrustedApplicationManager.class);
        TreeSet<TrustedApplicationInfo> trustedApplications = new TreeSet<TrustedApplicationInfo>(TrustedApplicationService.NAME_COMPARATOR);
        trustedApplications.addAll(trustedAppManager.getAll());
        this.logMsg.outputHeader("Trusted Applications");
        this.logMsg.outputProperty("Instance Count", String.valueOf(trustedApplications.size()));
        this.logMsg.add("");
        for (Object e : trustedApplications) {
            TrustedApplicationInfo applicationInfo = (TrustedApplicationInfo)((Object)e);
            this.logMsg.outputProperty("Application Name", applicationInfo.getName());
            this.logMsg.outputProperty("Matching URLs", applicationInfo.getUrlMatch(), 2);
            this.logMsg.outputProperty("Matching IP", applicationInfo.getIpMatch(), 2);
        }
    }

    private void silentlyClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String maskURL(String url) {
        if (url == null) {
            return null;
        }
        Pattern passwordRegex = Pattern.compile("password=[^&;]*", 2);
        return passwordRegex.matcher(url).replaceAll("password=****");
    }

    private String getLogPath(JiraHome jiraHome) {
        JiraLogLocator locator = new JiraLogLocator(jiraHome);
        File logFile = locator.findJiraLogFile();
        if (logFile != null) {
            return logFile.getAbsolutePath();
        }
        return STRANGELY_UNKNOWN;
    }

    private static class ListenerRepresentation
    implements Comparable<ListenerRepresentation> {
        private final String name;
        private final String clazz;
        private final GenericValue gv;

        ListenerRepresentation(GenericValue gv) {
            this.name = gv.getString("name");
            this.clazz = gv.getString("clazz");
            this.gv = gv;
        }

        @Override
        public int compareTo(ListenerRepresentation that) {
            int rc = this.name.compareTo(that.name);
            if (rc == 0) {
                rc = this.clazz.compareTo(that.clazz);
            }
            return rc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListenerRepresentation)) {
                return false;
            }
            ListenerRepresentation that = (ListenerRepresentation)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
            return result;
        }
    }
}

