/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.appconsistency.db.Build178SchemaCheck;
import com.atlassian.jira.appconsistency.db.BuildVersionCheck;
import com.atlassian.jira.appconsistency.db.CollationCheckFactory;
import com.atlassian.jira.appconsistency.db.EmbeddedDatabaseTypeCheck;
import com.atlassian.jira.appconsistency.db.MinimumUpgradableVersionCheck;
import com.atlassian.jira.appconsistency.db.PostgresSchemaConfigCheck;
import com.atlassian.jira.appconsistency.db.PublicSchemaConfigCheck;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.ManagedDatasourceInfoSupplier;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.scheduler.OracleClusteredJobParametersTypeFixer;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraDatabaseConfigChecklist {
    private static final Logger log = LoggerFactory.getLogger(JiraDatabaseConfigChecklist.class);
    private final JiraStartupLogger startupLogger = new JiraStartupLogger();
    private final StartupCheck[] checklist;
    private volatile boolean checksDone;
    private volatile boolean success;
    private StartupCheck failedStartupCheck = null;

    public JiraDatabaseConfigChecklist(DatabaseConfigurationManager databaseConfigurationManager, JiraProperties jiraProperties, BuildUtilsInfo buildUtilsInfo) {
        this(new StartupCheck[]{new EmbeddedDatabaseTypeCheck(databaseConfigurationManager.getDatabaseConfiguration()), new PostgresSchemaConfigCheck(new ManagedDatasourceInfoSupplier(databaseConfigurationManager), new ExternalLinkUtilImpl()), new OracleClusteredJobParametersTypeFixer(databaseConfigurationManager).asStartupCheck(), CollationCheckFactory.createCollationCheck(databaseConfigurationManager), new PublicSchemaConfigCheck(new ManagedDatasourceInfoSupplier(databaseConfigurationManager)), new MinimumUpgradableVersionCheck(buildUtilsInfo), new Build178SchemaCheck(), new BuildVersionCheck(jiraProperties, databaseConfigurationManager, buildUtilsInfo)});
    }

    JiraDatabaseConfigChecklist(StartupCheck[] checklist) {
        this.checklist = checklist;
    }

    public boolean startupOK() {
        if (!this.checksDone) {
            log.debug("Checks not done, doing them now");
            this.success = this.doStartupChecks();
            this.checksDone = true;
        }
        return this.success;
    }

    private boolean doStartupChecks() {
        log.debug("Doing database config checklist");
        for (StartupCheck startupCheck : this.checklist) {
            log.debug("Doing startup check " + startupCheck.getName());
            if (startupCheck.isOk()) continue;
            this.failedStartupCheck = startupCheck;
            ComponentManager.getInstance().extendBootstrapContainerForFailedStartup();
            return false;
        }
        return true;
    }

    public StartupCheck getFailedStartupCheck() {
        return this.failedStartupCheck;
    }
}

