/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRecoveryLauncher
implements JiraLauncher {
    private static final String DR_PROPERTY_KEY = "disaster.recovery";
    private static final Logger LOG = LoggerFactory.getLogger(IndexRecoveryLauncher.class);

    private boolean isStandaloneMode() {
        return !((ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class)).getOption(DR_PROPERTY_KEY) && !((ClusterManager)ComponentAccessor.getComponent(ClusterManager.class)).isClustered();
    }

    @Override
    public void start() {
        this.runIndexRecoveryJob();
    }

    protected void startIndexRecovery() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        if ("true".equals(applicationProperties.getString("jira.setup")) && this.isStandaloneMode()) {
            IndexRecoveryManager recoveryManager = (IndexRecoveryManager)ComponentAccessor.getComponent(IndexRecoveryManager.class);
            try {
                DateUtils.DateRange dateRange = recoveryManager.getDurationToRecover();
                if (dateRange == null) {
                    return;
                }
                long difference = Math.abs(dateRange.endDate.getTime() - dateRange.startDate.getTime());
                if (difference > TimeUnit.DAYS.toMillis(1L)) {
                    LOG.info("Issue index is out of date with the database by more than 24 hours. Automatic recovery is not attempted");
                    return;
                }
                if (difference > 1000L) {
                    LOG.info("Recover Issue Index - start");
                }
                recoveryManager.reindexIssuesIn(dateRange, TaskProgressSink.NULL_SINK);
                if (difference > 1000L) {
                    LOG.info("Recover Issue Index - end");
                }
            }
            catch (IndexException e) {
                LOG.error("Automatic index recovery failed", (Throwable)e);
            }
            catch (SearchException e) {
                LOG.error("Automatic index recovery failed", (Throwable)e);
            }
            catch (RuntimeException e) {
                LOG.error("Automatic index recovery failed", (Throwable)e);
            }
        }
    }

    private void runIndexRecoveryJob() {
        JobRunnerKey runnerKey = JobRunnerKey.of((String)"com.atlassian.jira.DefaultJiraLauncher.IndexRecovery");
        SchedulerService schedulerService = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        schedulerService.registerJobRunner(runnerKey, r -> {
            this.startIndexRecovery();
            return JobRunnerResponse.success();
        });
        try {
            schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)runnerKey).withSchedule(Schedule.runOnce((Date)new Date())));
        }
        catch (SchedulerServiceException e) {
            LOG.error("Index recovery not scheduled", (Throwable)e);
        }
    }

    @Override
    public void stop() {
    }
}

