/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.instrumentation.InstrumentationListenerManager;
import com.atlassian.jira.instrumentation.jdbc.JdbcCollector;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.upgrade.ConnectionKeeper;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(DatabaseLauncher.class);
    private static final String HSQLDB = "hsql";
    private static final int CK_CONNECTIONS = 1;
    private static final int CK_SLEEPTIME = 300000;
    private static final String TRANSACTION_ISOLATION_PROPERTY = "jira.transaction.isolation";
    private static final String TRANSACTION_DISABLE_PROPERTY = "jira.transaction.disable";
    private static final String JIRA_INSTRUMENTATION_JDBC = "jira.instrumentation.jdbc";
    private static final String JIRA_INSTRUMENTATION_JDBC_EXECUTION_TIMES = "jira.instrumentation.jdbc.execution.times";
    private final JiraProperties jiraSystemProperties;
    private volatile ConnectionKeeper connectionKeeper;
    private final ComponentReference<DatabaseConfigurationManager> configManagerRef = ComponentAccessor.getComponentReference(DatabaseConfigurationManager.class);

    public DatabaseLauncher(JiraProperties jiraSystemProperties) {
        this.jiraSystemProperties = jiraSystemProperties;
    }

    @Override
    public void start() {
        DatabaseConfig databaseConfig = ((DatabaseConfigurationManager)this.configManagerRef.get()).getDatabaseConfiguration();
        if (databaseConfig == null) {
            log.error("No database config found");
            return;
        }
        DatasourceInfo datasourceInfo = databaseConfig.getDatasourceInfo();
        if (datasourceInfo == null) {
            log.error("No datasource info found");
            return;
        }
        this.showEmbeddedDbWarning(databaseConfig);
        this.setupHsqlHacks(datasourceInfo);
        this.initDatabaseTransactions(datasourceInfo);
        this.cleanupDatabaseTableNames();
        new JiraStartupLogger().printStartingMessageDatabaseOK();
        if (this.jiraSystemProperties.getBoolean(JIRA_INSTRUMENTATION_JDBC).booleanValue()) {
            ComponentAccessor.getComponentSafely(InstrumentationListenerManager.class).ifPresent(instrumentationListenerManager -> {
                try {
                    Class.forName("com.atlassian.instrumentation.driver.JdbcThreadLocalCollector");
                    instrumentationListenerManager.addRequestListener(new JdbcCollector(this.jiraSystemProperties.getBoolean(JIRA_INSTRUMENTATION_JDBC_EXECUTION_TIMES)));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void stop() {
        this.shutdownHsqlHacks();
        DatabaseConfig config = ((DatabaseConfigurationManager)this.configManagerRef.get()).getDatabaseConfiguration();
        if (config != null) {
            String name = config.getDatasourceName();
            EntityConfigUtil entityConfigUtil = EntityConfigUtil.getInstance();
            if (entityConfigUtil.getDelegatorInfo(name) != null) {
                entityConfigUtil.removeDelegator(name);
            }
            if (entityConfigUtil.getDatasourceInfo(name) != null) {
                entityConfigUtil.removeDatasource(name);
            }
        }
    }

    private void showEmbeddedDbWarning(DatabaseConfig databaseConfig) {
        if (databaseConfig.isEmbeddedDatabase()) {
            String message1 = databaseConfig.getDatabaseType() + " is an in-memory database, and susceptible to corruption when abnormally terminated.";
            String message2 = "DO NOT USE IN PRODUCTION, please switch to a regular database.";
            String line = StringUtils.repeat((String)"*", (int)Math.max(message1.length(), "DO NOT USE IN PRODUCTION, please switch to a regular database.".length()));
            String newLine = this.jiraSystemProperties.getProperty("line.separator");
            log.warn(newLine + newLine + line + newLine + message1 + newLine + "DO NOT USE IN PRODUCTION, please switch to a regular database." + newLine + line + newLine);
        }
    }

    private void setupHsqlHacks(DatasourceInfo datasourceInfo) {
        if (HSQLDB.equals(datasourceInfo.getFieldTypeName())) {
            if (log.isDebugEnabled()) {
                log.debug("Will open 1 connections to keep the database alive.");
                log.debug("Starting ConnectionKeeper with datasource name '" + datasourceInfo.getName() + "', connections to open '" + 1 + "' and sleep time '" + 300000 + "' milliseconds.");
            }
            this.connectionKeeper = new ConnectionKeeper(datasourceInfo.getName(), 1, 300000);
            this.connectionKeeper.start();
        }
    }

    private void shutdownHsqlHacks() {
        if (this.connectionKeeper != null) {
            this.connectionKeeper.shutdown();
        }
    }

    private void initDatabaseTransactions(DatasourceInfo datasourceInfo) {
        boolean startTransaction = true;
        Integer isolationLevel = null;
        if (datasourceInfo != null) {
            if (HSQLDB.equals(datasourceInfo.getFieldTypeName())) {
                log.info("Setting isolation level to '1' as this is the only isolation level 'hsql' supports.");
                isolationLevel = 1;
            }
        } else {
            log.info("Cannot get datasource information from server. Probably using JBoss. If using HSQLDB please set 'jira.transaction.isolation' to '1'. Other databases should not need this property.");
        }
        try {
            String isolationProperty;
            if (this.jiraSystemProperties.getBoolean(TRANSACTION_DISABLE_PROPERTY).booleanValue()) {
                log.info("System property + 'jira.transaction.disable' set to true.");
                startTransaction = false;
            }
            if ((isolationProperty = this.jiraSystemProperties.getProperty(TRANSACTION_ISOLATION_PROPERTY)) != null) {
                try {
                    log.info("System property + 'jira.transaction.isolation' set to '" + isolationProperty + "'. Overriding default.");
                    isolationLevel = Integer.valueOf(isolationProperty);
                }
                catch (NumberFormatException e) {
                    log.error("The 'jira.transaction.isolation' is set to a non-numeric value '" + isolationProperty + "'.");
                }
            }
        }
        catch (SecurityException e) {
            log.warn("There was a security problem trying to read transaction configuration system properties. This usually occurs if you are running JIRA with a security manager. As these system properties are not required to be set (unless you are trying to solve another problem) JIRA should function properly.", (Throwable)e);
        }
        log.info("Database transactions enabled: " + startTransaction);
        CoreTransactionUtil.setUseTransactions(startTransaction);
        if (isolationLevel != null) {
            log.info("Database transaction isolation level: " + isolationLevel);
            CoreTransactionUtil.setIsolationLevel(isolationLevel);
        } else {
            log.info("Using JIRA's default for database transaction isolation level: " + CoreTransactionUtil.getIsolationLevel());
        }
    }

    private void cleanupDatabaseTableNames() {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        boolean needsTablesRecreated = false;
        try {
            ofBizDelegator.findByAnd("MovedIssueKey", (Map)FieldMap.build((String)"oldIssueKey", (Object)"bogus"));
        }
        catch (DataAccessException ex) {
            log.warn("JRADEV-23357: unable to select from the 'MovedIssueKey' entity.");
            this.cleanupDatabaseTableName("MOVED_ISSUE_KEY");
            needsTablesRecreated = true;
        }
        try {
            ofBizDelegator.findByAnd("ProjectKey", (Map)FieldMap.build((String)"projectKey", (Object)"bogus"));
        }
        catch (DataAccessException ex) {
            log.warn("JRADEV-23357: unable to select from the 'ProjectKey' entity.");
            this.cleanupDatabaseTableName("PROJECT_KEY");
            needsTablesRecreated = true;
        }
        if (needsTablesRecreated) {
            this.kickOfbizInTheGuts();
        }
    }

    @SuppressWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Dynamic SQL does not come from user input so no SQL injection is possible.")
    private void cleanupDatabaseTableName(String tableName) {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = DefaultOfBizConnectionFactory.getInstance().getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            if (count > 0) {
                throw new IllegalStateException("Need to rename the " + tableName + " table, but there is existing data in it. Please contact Atlassian Support.");
            }
            log.info("We need to change the case of table '" + tableName + "'... will drop table and then recreate.");
            stmt = con.createStatement();
            stmt.execute("DROP TABLE " + tableName);
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeQuietly(rs);
                DatabaseUtil.closeQuietly(stmt);
                DatabaseUtil.closeQuietly(con);
                throw throwable;
            }
        }
        DatabaseUtil.closeQuietly(rs);
        DatabaseUtil.closeQuietly(stmt);
        DatabaseUtil.closeQuietly(con);
    }

    private void kickOfbizInTheGuts() {
        DelegatorInterface delegatorInterface = (DelegatorInterface)ComponentAccessor.getComponent(DelegatorInterface.class);
        Map modelEntities = delegatorInterface.getModelEntityMapByGroup("default");
        try {
            GenericHelper helper = delegatorInterface.getEntityHelper("ProjectKey");
            helper.checkDataSource(modelEntities, null, true);
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }
}

