/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.AuthenticatedUserShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;

public class AuthenticatedUserShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;

    public AuthenticatedUserShareTypeValidator(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.equals((String)"permission-type", (Object)AuthenticatedUserShareType.TYPE, (Object)permission.getType());
        boolean hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInUser());
        if (!hasPermission) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        }
        return hasPermission;
    }

    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        Assertions.equals((String)"permission-type", (Object)AuthenticatedUserShareType.TYPE, (Object)searchParameter.getType());
        return true;
    }
}

