/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.scheduler.cron.ConversionResult;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.InBuiltServiceTypes;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceConfigStore;
import com.atlassian.jira.service.ServiceException;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.ServiceRunner;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@TenantInfo(value=TenantAware.UNRESOLVED)
public class DefaultServiceManager
implements ServiceManager,
Startable {
    static final String RESCHEDULE_SERVICE = "Reschedule Service";
    static final String UNSCHEDULE_SERVICE = "Unschedule Service";
    private static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.DefaultServiceManager.caches.request";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceManager.class);
    private static final JobRunnerKey SERVICE_JOB_KEY = JobRunnerKey.of((String)DefaultServiceManager.class.getName());
    static final String UPDATE_LOCK = DefaultServiceManager.class.getName() + ".updateLock";
    private final ServiceConfigStore serviceConfigStore;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<Map<Long, JiraServiceContainer>> servicesReference;
    private final ComponentClassManager componentClassManager;
    private final PermissionManager permissionManager;
    private final InBuiltServiceTypes inBuiltServiceTypes;
    private final SchedulerService schedulerService;
    private final ClusterMessagingService messagingService;
    private final LazyReference<ClusterLock> updateLockRef;
    private final MessageConsumer messageConsumer;

    public DefaultServiceManager(ServiceConfigStore serviceConfigStore, ComponentClassManager componentClassManager, PermissionManager permissionManager, InBuiltServiceTypes inBuiltServiceTypes, SchedulerService schedulerService, SwitchingCacheFactory cacheFactory, final ClusterLockService clusterLockService, ClusterMessagingService messagingService) {
        this.permissionManager = permissionManager;
        this.inBuiltServiceTypes = inBuiltServiceTypes;
        this.schedulerService = schedulerService;
        this.messagingService = messagingService;
        this.serviceConfigStore = (ServiceConfigStore)Assertions.notNull((String)"serviceConfigStore", (Object)serviceConfigStore);
        this.componentClassManager = componentClassManager;
        this.servicesReference = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".servicesReference", this::loadServiceCache, DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
        this.updateLockRef = new LazyReference<ClusterLock>(){

            protected ClusterLock create() throws Exception {
                return clusterLockService.getLockForName(UPDATE_LOCK);
            }
        };
        this.messageConsumer = new MessageConsumer();
    }

    public void start() {
        this.messagingService.registerListener(RESCHEDULE_SERVICE, (ClusterMessageConsumer)this.messageConsumer);
        this.messagingService.registerListener(UNSCHEDULE_SERVICE, (ClusterMessageConsumer)this.messageConsumer);
        this.schedulerService.registerJobRunner(SERVICE_JOB_KEY, (JobRunner)new ServiceRunner());
        this.ensureServicesScheduled();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        if (!Boolean.TRUE.equals(event.getProperty("ServiceEvent"))) {
            this.refreshAll();
        }
    }

    public Collection<JiraServiceContainer> getServices() {
        return Collections.unmodifiableCollection(this.getServiceCache().values());
    }

    public Iterable<JiraServiceContainer> getServicesManageableBy(ApplicationUser user) {
        if (Users.isAnonymous((ApplicationUser)user)) {
            return ImmutableSet.of();
        }
        if (this.permissionManager.hasPermission(44, user)) {
            return this.getServices();
        }
        if (this.permissionManager.hasPermission(0, user)) {
            Set<String> names = DefaultServiceManager.getServiceClassNames(this.inBuiltServiceTypes.manageableBy(user));
            return Iterables.filter(this.getServices(), service -> names.contains(service.getServiceClass()));
        }
        return ImmutableSet.of();
    }

    private static Set<String> getServiceClassNames(Set<InBuiltServiceTypes.InBuiltServiceType> builtInTypes) {
        HashSet names = Sets.newHashSetWithExpectedSize((int)builtInTypes.size());
        for (InBuiltServiceTypes.InBuiltServiceType serviceType : builtInTypes) {
            names.add(serviceType.getType().getName());
        }
        return names;
    }

    public void runNow(long serviceId) throws Exception {
        JiraServiceContainer jiraServiceContainer = this.getServiceWithId(serviceId);
        if (jiraServiceContainer == null) {
            throw new ServiceException("Service with id '" + serviceId + "' was not found");
        }
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)SERVICE_JOB_KEY).withSchedule(Schedule.runOnce(null)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)SERVICE_ID_KEY, (Object)serviceId));
        JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(config);
        LOG.debug("JIRA Service '" + jiraServiceContainer.getName() + "' scheduled for immediate execution with job id '" + jobId + '\'');
    }

    public Iterable<JiraServiceContainer> getServicesForExecution(long time) {
        return Collections.emptyList();
    }

    public boolean containsServiceWithId(Long id) {
        return this.getServiceCache().containsKey(id);
    }

    public void refreshAll() {
        this.servicesReference.reset();
        this.ensureServicesScheduled();
    }

    public JiraServiceContainer getServiceWithId(Long id) {
        return this.getServiceCache().get(id);
    }

    @Nullable
    public JiraServiceContainer getServiceWithName(String name) {
        JiraServiceContainer jiraServiceContainer = this.serviceConfigStore.getServiceConfigForName(name);
        if (jiraServiceContainer != null && this.getServiceCache().containsKey(jiraServiceContainer.getId())) {
            return jiraServiceContainer;
        }
        return null;
    }

    public JiraServiceContainer addService(String name, String serviceClassName, long delay) throws ServiceException, ClassNotFoundException {
        return this.addService(name, serviceClassName, delay, null);
    }

    public JiraServiceContainer addService(String name, String serviceClassName, long delay, Map<String, String[]> params) throws ServiceException, ClassNotFoundException {
        if (StringUtils.isBlank((String)serviceClassName)) {
            throw new ServiceException("The service class name must not be blank");
        }
        Class serviceClass = this.componentClassManager.loadClass(serviceClassName);
        return this.addService(name, (Class<? extends JiraService>)serviceClass, delay, params);
    }

    public JiraServiceContainer addService(String name, Class<? extends JiraService> serviceClass, long delay) throws ServiceException {
        return this.addService(name, serviceClass, delay, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JiraServiceContainer addService(String name, Class<? extends JiraService> serviceClass, long delay, Map<String, String[]> params) throws ServiceException {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.addServiceConfig(name, serviceClass, delay);
            if (params != null) {
                this.serviceConfigStore.editServiceConfig(serviceContainer, delay, params);
            }
            try {
                this.scheduleJob(serviceContainer);
            }
            catch (SchedulerServiceException e) {
                throw new RuntimeException(e);
            }
            this.servicesReference.reset();
            JiraServiceContainer jiraServiceContainer = serviceContainer;
            return jiraServiceContainer;
        }
        finally {
            updateLock.unlock();
        }
    }

    public JiraServiceContainer addService(String name, String serviceClassName, String cronExpression) throws ServiceException, ClassNotFoundException {
        return this.addService(name, serviceClassName, cronExpression, null);
    }

    public JiraServiceContainer addService(String name, Class<? extends JiraService> serviceClass, String cronExpression) throws ServiceException {
        return this.addService(name, serviceClass, cronExpression, null);
    }

    public JiraServiceContainer addService(String name, String serviceClassName, String cronExpression, Map<String, String[]> params) throws ServiceException, ClassNotFoundException {
        return this.addService(name, serviceClassName, cronExpression, TimeUnit.DAYS.toMillis(1L), params);
    }

    public JiraServiceContainer addService(String name, String serviceClassName, String cronExpression, long delay, Map<String, String[]> params) throws ServiceException, ClassNotFoundException {
        if (StringUtils.isBlank((String)serviceClassName)) {
            throw new ServiceException("The service class name must not be blank");
        }
        Class serviceClass = this.componentClassManager.loadClass(serviceClassName);
        return this.addService(name, serviceClass, cronExpression, delay, params);
    }

    public JiraServiceContainer addService(String name, Class<? extends JiraService> serviceClass, String cronExpression, @Nullable Map<String, String[]> params) throws ServiceException {
        return this.addService(name, serviceClass, cronExpression, TimeUnit.DAYS.toMillis(1L), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JiraServiceContainer addService(String name, Class<? extends JiraService> serviceClass, String cronExpression, long delay, @Nullable Map<String, String[]> params) throws ServiceException {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.addServiceConfig(name, serviceClass, cronExpression, delay);
            if (params != null) {
                this.serviceConfigStore.editServiceConfig(serviceContainer, cronExpression, params);
            }
            try {
                this.scheduleJob(serviceContainer);
            }
            catch (SchedulerServiceException e) {
                throw new RuntimeException(e);
            }
            this.servicesReference.reset();
            JiraServiceContainer jiraServiceContainer = serviceContainer;
            return jiraServiceContainer;
        }
        finally {
            updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editServiceByName(String name, long delay, Map<String, String[]> params) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForName(name);
            if (serviceContainer == null) {
                throw new IllegalArgumentException("There is no ServiceConfig with name: " + name);
            }
            if (!serviceContainer.isUsable()) {
                throw new IllegalStateException("You can not edit an unloadable service");
            }
            this.serviceConfigStore.editServiceConfig(serviceContainer, delay, params);
            this.scheduleJob(serviceContainer);
            this.servicesReference.reset();
        }
        finally {
            updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editService(Long id, long delay, Map<String, String[]> params) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForId(id);
            this.serviceConfigStore.editServiceConfig(serviceContainer, delay, params);
            this.scheduleJob(serviceContainer);
            this.servicesReference.reset();
        }
        finally {
            updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editServiceByName(String name, String cronExpression, Map<String, String[]> params) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForName(name);
            if (serviceContainer == null) {
                throw new IllegalArgumentException("There is no ServiceConfig with name: " + name);
            }
            if (!serviceContainer.isUsable()) {
                throw new IllegalStateException("You can not edit an unloadable service");
            }
            this.serviceConfigStore.editServiceConfig(serviceContainer, cronExpression, params);
            this.scheduleJob(serviceContainer);
            this.servicesReference.reset();
        }
        finally {
            updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editService(Long id, String cronExpression, Map<String, String[]> params) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForId(id);
            this.serviceConfigStore.editServiceConfig(serviceContainer, cronExpression, params);
            this.scheduleJob(serviceContainer);
            this.servicesReference.reset();
        }
        finally {
            updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceByName(String name) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer jiraServiceContainer = this.serviceConfigStore.getServiceConfigForName(name);
            if (jiraServiceContainer == null) {
                throw new IllegalArgumentException("No services with name '" + name + "' exist.");
            }
            this.removeService(jiraServiceContainer);
        }
        finally {
            updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(Long id) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer jiraServiceContainer = this.serviceConfigStore.getServiceConfigForId(id);
            this.removeService(jiraServiceContainer);
        }
        finally {
            updateLock.unlock();
        }
    }

    private void removeService(JiraServiceContainer jiraServiceContainer) {
        this.serviceConfigStore.removeServiceConfig(jiraServiceContainer);
        this.unscheduleJob(jiraServiceContainer);
        this.servicesReference.reset();
    }

    public void refreshService(Long id) throws Exception {
        this.refreshService(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshService(Long id, boolean notify) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForId(id);
            if (serviceContainer != null) {
                this.scheduleJob(serviceContainer, notify);
            }
            this.servicesReference.reset();
        }
        finally {
            updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshServiceByName(String name) throws Exception {
        Lock updateLock = this.getUpdateLock();
        updateLock.lock();
        try {
            JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForName(name);
            if (serviceContainer != null) {
                this.scheduleJob(serviceContainer);
            }
            this.servicesReference.reset();
        }
        finally {
            updateLock.unlock();
        }
    }

    public ServiceManager.ServiceScheduleSkipper getScheduleSkipper() {
        throw new UnsupportedOperationException("The service skipper is no longer the way to run one service. Call 'runNow(long serviceId)' ");
    }

    @VisibleForTesting
    boolean picoContainerComponentsRegistered() {
        return ComponentManager.getInstance().getState().isComponentsRegistered();
    }

    private void unscheduleJob(Long serviceId) {
        this.schedulerService.unscheduleJob(DefaultServiceManager.toJobId(serviceId));
    }

    private void unscheduleJob(JiraServiceContainer jiraServiceContainer) {
        this.unscheduleJob(jiraServiceContainer.getId());
        if (jiraServiceContainer.isUsable() && jiraServiceContainer.isLocalService()) {
            this.messagingService.sendRemote(UNSCHEDULE_SERVICE, jiraServiceContainer.getId().toString());
        }
    }

    private void scheduleJob(JiraServiceContainer jiraServiceContainer) throws SchedulerServiceException {
        this.scheduleJob(jiraServiceContainer, true);
    }

    private void scheduleJob(JiraServiceContainer jiraServiceContainer, boolean notify) throws SchedulerServiceException {
        if (StringUtils.isNotEmpty((String)jiraServiceContainer.getCronExpression())) {
            this.scheduleCronJob(jiraServiceContainer);
        } else if (jiraServiceContainer.getDelay() > 0L) {
            this.scheduleSimpleJob(jiraServiceContainer);
        } else {
            return;
        }
        boolean localService = jiraServiceContainer.isLocalService();
        if (localService && notify) {
            this.messagingService.sendRemote(RESCHEDULE_SERVICE, jiraServiceContainer.getId().toString());
        }
    }

    private void scheduleCronJob(JiraServiceContainer jiraServiceContainer) throws SchedulerServiceException {
        boolean localService = jiraServiceContainer.isLocalService();
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)SERVICE_JOB_KEY).withSchedule(Schedule.forCronExpression((String)jiraServiceContainer.getCronExpression())).withRunMode(localService ? RunMode.RUN_LOCALLY : RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)SERVICE_ID_KEY, (Object)jiraServiceContainer.getId()));
        this.schedulerService.scheduleJob(DefaultServiceManager.toJobId(jiraServiceContainer.getId()), config);
    }

    private void scheduleSimpleJob(JiraServiceContainer jiraServiceContainer) throws SchedulerServiceException {
        Date nextFireTime = null;
        long lastRunMillis = jiraServiceContainer.getLastRun();
        long nextRunMillis = lastRunMillis > 0L ? lastRunMillis + jiraServiceContainer.getDelay() : System.currentTimeMillis();
        boolean localService = jiraServiceContainer.isLocalService();
        if (nextRunMillis > System.currentTimeMillis()) {
            nextFireTime = new Date(nextRunMillis);
        }
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)SERVICE_JOB_KEY).withSchedule(Schedule.forInterval((long)jiraServiceContainer.getDelay(), (Date)nextFireTime)).withRunMode(localService ? RunMode.RUN_LOCALLY : RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)SERVICE_ID_KEY, (Object)jiraServiceContainer.getId()));
        this.schedulerService.scheduleJob(DefaultServiceManager.toJobId(jiraServiceContainer.getId()), config);
    }

    private static JobId toJobId(long serviceId) {
        return JobId.of((String)(JiraService.class.getName() + ':' + serviceId));
    }

    private Map<Long, JiraServiceContainer> getServiceCache() {
        if (!this.picoContainerComponentsRegistered()) {
            throw new IllegalStateException("It is illegal to call the ServiceManager before all components are loaded. Please use " + Startable.class + " to get notified when JIRA has started.");
        }
        return this.servicesReference.get();
    }

    private void ensureServicesScheduled() {
        this.getServices().stream().filter(JiraServiceContainer::isUsable).forEach(this::ensureServiceScheduled);
    }

    private void ensureServiceScheduled(JiraServiceContainer jiraServiceContainer) {
        this.convertToCron(jiraServiceContainer);
        if (this.schedulerService.getJobDetails(DefaultServiceManager.toJobId(jiraServiceContainer.getId())) == null) {
            try {
                this.scheduleJob(jiraServiceContainer);
            }
            catch (Exception e) {
                LOG.warn("Unable to schedule service '" + jiraServiceContainer.getName() + "', " + e.getMessage());
            }
        }
    }

    private void convertToCron(JiraServiceContainer jiraServiceContainer) {
        if (jiraServiceContainer.getCronExpression() == null) {
            try {
                ConversionResult result = new SimpleToCronTriggerConverter().convertToCronString(new Date(jiraServiceContainer.getLastRun()), jiraServiceContainer.getDelay());
                String cronExpression = result.cronString;
                this.editService(jiraServiceContainer.getId(), cronExpression, DefaultServiceManager.propertiesToMap(jiraServiceContainer.getProperties()));
            }
            catch (Exception e) {
                LOG.warn("Unable to convert service entry to cron format", (Throwable)e);
            }
        }
    }

    private static Map<String, String[]> propertiesToMap(PropertySet properties) {
        HashMap parms = Maps.newHashMap();
        if (properties != null) {
            for (Object key : properties.getKeys()) {
                String[] value = new String[]{properties.getString((String)key)};
                parms.put((String)key, value);
            }
        }
        return parms;
    }

    private Lock getUpdateLock() {
        return (Lock)this.updateLockRef.get();
    }

    private Map<Long, JiraServiceContainer> loadServiceCache() {
        try {
            Collection<JiraServiceContainer> serviceConfigs = this.serviceConfigStore.getAllServiceConfigs();
            if (serviceConfigs == null || serviceConfigs.isEmpty()) {
                LOG.debug("No Services to Load");
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (JiraServiceContainer jiraServiceContainer : serviceConfigs) {
                builder.put((Object)jiraServiceContainer.getId(), (Object)jiraServiceContainer);
            }
            return builder.build();
        }
        catch (Exception t) {
            LOG.error("Could not configure services: ", (Throwable)t);
            return ImmutableMap.of();
        }
    }

    private class MessageConsumer
    implements ClusterMessageConsumer {
        private MessageConsumer() {
        }

        public void receive(String channel, String message, String senderId) {
            if (StringUtils.isNumeric((String)message)) {
                try {
                    if (DefaultServiceManager.RESCHEDULE_SERVICE.equals(channel)) {
                        DefaultServiceManager.this.refreshService(Long.valueOf(message), false);
                    } else if (DefaultServiceManager.UNSCHEDULE_SERVICE.equals(channel)) {
                        DefaultServiceManager.this.unscheduleJob(Long.valueOf(message));
                    }
                }
                catch (Exception e) {
                    LOG.error("Error refreshing services", (Throwable)e);
                }
            }
        }
    }
}

