/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.jira.servermetrics.NestedRequestsMetricsCollector;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.servermetrics.TimingInformation;
import com.google.common.base.Ticker;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;

@ParametersAreNonnullByDefault
@ThreadSafe
public class MultiThreadedRequestMetricsCollector
implements ServerMetricsDetailCollector {
    private final ThreadLocal<NestedRequestsMetricsCollector> perThreadCollectors;
    private final Ticker ticker;

    public MultiThreadedRequestMetricsCollector(Ticker ticker) {
        this.ticker = ticker;
        this.perThreadCollectors = ThreadLocal.withInitial(() -> new NestedRequestsMetricsCollector(this.ticker));
    }

    public void startCollectionInCurrentThread() {
        this.perThreadCollectors.get().startCollectionInCurrentThread();
    }

    public void checkpointReached(String checkpointName) {
        this.perThreadCollectors.get().checkpointReached(checkpointName);
    }

    public void checkpointReachedOnce(String checkpointName) {
        this.perThreadCollectors.get().checkpointReachedOnce(checkpointName);
    }

    public void checkpointReachedOverride(String checkpointName) {
        this.perThreadCollectors.get().checkpointReachedOverride(checkpointName);
    }

    public void addTimeSpentInActivity(String activityName, Duration duration) {
        this.perThreadCollectors.get().addTimeSpentInActivity(activityName, duration);
    }

    public void setTimeSpentInActivity(String activityName, Duration duration) {
        this.perThreadCollectors.get().setTimeSpentInActivity(activityName, duration);
    }

    public Optional<TimingInformation> finishCollectionInCurrentThread() {
        return this.perThreadCollectors.get().finishCollection();
    }
}

