/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.util.AbstractGroupMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupToNotificationSchemeMapper
extends AbstractGroupMapper {
    public static final String GROUP_DROPDOWN = "Group_Dropdown";
    private final NotificationSchemeManager notificationSchemeManager;

    public GroupToNotificationSchemeMapper(NotificationSchemeManager notificationSchemeManager) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.setGroupMapping(this.init());
    }

    private Map<String, Set<Scheme>> init() {
        HashMap<String, Set<Scheme>> mapping = new HashMap<String, Set<Scheme>>();
        List schemes = this.notificationSchemeManager.getSchemeObjects();
        for (Scheme notificationScheme : schemes) {
            Collection entities = notificationScheme.getEntities();
            for (SchemeEntity notificationRecord : entities) {
                if (!GROUP_DROPDOWN.equals(notificationRecord.getType())) continue;
                this.addEntry(mapping, notificationRecord.getParameter(), notificationScheme);
            }
        }
        return mapping;
    }
}

