/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationBuilder;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationData;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationManager;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Null;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrustedApplicationManager
implements TrustedApplicationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultTrustedApplicationManager.class);
    private final TrustedApplicationStore store;

    public DefaultTrustedApplicationManager(TrustedApplicationStore store) {
        Null.not("store", store);
        this.store = store;
    }

    @Override
    public Set<TrustedApplicationInfo> getAll() {
        Set<TrustedApplicationData> allData = this.store.getAll();
        LinkedHashSet<TrustedApplicationInfo> result = new LinkedHashSet<TrustedApplicationInfo>(allData.size());
        for (TrustedApplicationData data : allData) {
            result.add(this.transform(data));
        }
        return result;
    }

    @Override
    public TrustedApplicationInfo get(String applicationId) {
        return this.transform(this.store.getByApplicationId(applicationId));
    }

    @Override
    public TrustedApplicationInfo get(long id) {
        return this.transform(this.store.getById(id));
    }

    @Override
    public boolean delete(ApplicationUser user, long id) {
        log.info("{} is deleting TrustedApplication: {}", (Object)user, (Object)id);
        return this.store.delete(id);
    }

    @Override
    public boolean delete(ApplicationUser user, String applicationId) {
        return this.store.delete(applicationId);
    }

    @Override
    public TrustedApplicationInfo store(ApplicationUser user, TrustedApplicationInfo info) {
        return this.store(user.getName(), info);
    }

    @Override
    public TrustedApplicationInfo store(String user, TrustedApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info(user + " is storing TrustedApplication: " + info.getNumericId() + " applicationId: " + info.getID());
        }
        long id = info.getNumericId();
        TrustedApplicationBuilder builder = new TrustedApplicationBuilder();
        if (id > 0L) {
            TrustedApplicationData data = this.store.getById(id);
            if (data == null) {
                throw new IllegalArgumentException("Attempting to update non-existant TrustedApplication: " + info.getID());
            }
            if (!data.getApplicationId().equals(info.getID())) {
                throw new IllegalArgumentException("Cannot change the TrustedApplication ID from: " + data.getApplicationId() + " to: " + info.getID());
            }
            builder.set(data);
        }
        builder.set(info);
        Date now = new Date();
        if (id == 0L) {
            builder.setCreated(now);
            builder.setCreatedBy(user);
        }
        builder.setUpdated(now);
        builder.setUpdatedBy(user);
        builder.set(this.store.store(builder.toData()));
        return builder.toInfo();
    }

    private TrustedApplicationInfo transform(TrustedApplicationData data) {
        return data == null ? null : new TrustedApplicationBuilder().set(data).toInfo();
    }
}

