/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.plugin.ProjectPermissionOverrideModuleDescriptor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class ProjectPermissionOverrideDescriptorCache
implements Startable {
    private EventPublisher eventPublisher;
    private ResettableLazyReference<List<ProjectPermissionOverrideModuleDescriptor>> enabledModuleDescriptors;

    public ProjectPermissionOverrideDescriptorCache(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.enabledModuleDescriptors = new ResettableLazyReference<List<ProjectPermissionOverrideModuleDescriptor>>(){

            protected List<ProjectPermissionOverrideModuleDescriptor> create() throws Exception {
                return ImmutableList.copyOf((Collection)ComponentAccessor.getPluginAccessor().getEnabledModuleDescriptorsByClass(ProjectPermissionOverrideModuleDescriptor.class));
            }
        };
    }

    @EventListener
    public void onPluginModuleEnabledEvent(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof ProjectPermissionOverrideModuleDescriptor) {
            this.reloadCache();
        }
    }

    @EventListener
    public void onPluginModuleDisabledEvent(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof ProjectPermissionOverrideModuleDescriptor) {
            this.reloadCache();
        }
    }

    public List<ProjectPermissionOverrideModuleDescriptor> getProjectPermissionOverrideDescriptors() {
        return (List)this.enabledModuleDescriptors.get();
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @VisibleForTesting
    protected synchronized void reloadCache() {
        this.enabledModuleDescriptors.reset();
    }
}

