/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class ReleaseNoteManager {
    private static final Logger log = LoggerFactory.getLogger(ReleaseNoteManager.class);
    public static final String RELEASE_NOTE_NAME = "jira.releasenotes.templatenames";
    public static final String RELEASE_NOTE_DEFAULT = "jira.releasenotes.default";
    public static final String RELEASE_NOTE_TEMPLATE = "jira.releasenotes.templates";
    public static final String TEMPLATES_DIR = "templates/jira/project/releasenotes/";
    private Map<String, String> styles;
    private final ApplicationProperties applicationProperties;
    private final VelocityTemplatingEngine templatingEngine;
    private final ConstantsManager constantsManager;
    private final SearchProvider searchProvider;
    private final CustomFieldManager customFieldManager;

    public ReleaseNoteManager(ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, ConstantsManager constantsManager, SearchProvider searchProvider, CustomFieldManager customFieldManager) {
        this.applicationProperties = applicationProperties;
        this.templatingEngine = templatingEngine;
        this.constantsManager = constantsManager;
        this.searchProvider = searchProvider;
        this.customFieldManager = customFieldManager;
    }

    public Map<String, String> getStyles() {
        if (this.styles == null) {
            this.loadReleaseNoteTemplates();
        }
        return this.styles;
    }

    private List<String> splitString(String strings) {
        if (strings == null) {
            return Collections.emptyList();
        }
        ArrayList stringList = Lists.newArrayList();
        StringTokenizer tokenizer = new StringTokenizer(strings, ",");
        while (tokenizer.hasMoreTokens()) {
            stringList.add(tokenizer.nextToken().trim());
        }
        return stringList;
    }

    private void loadReleaseNoteTemplates() {
        List<String> allReleaseNoteNames = this.splitString(this.applicationProperties.getDefaultBackedString(RELEASE_NOTE_NAME));
        List<String> allReleaseNoteTemplates = this.splitString(this.applicationProperties.getDefaultBackedString(RELEASE_NOTE_TEMPLATE));
        if (allReleaseNoteTemplates.size() != allReleaseNoteNames.size()) {
            throw new RuntimeException("Error loading release notes; differing numbers of names and templates specified in properties file.");
        }
        this.styles = new HashMap<String, String>(allReleaseNoteTemplates.size());
        for (int i = 0; i < allReleaseNoteNames.size(); ++i) {
            this.styles.put(allReleaseNoteNames.get(i), allReleaseNoteTemplates.get(i));
        }
    }

    public String getReleaseNote(Action action, String releaseNoteStyleName, Version version, ApplicationUser user, Project project) {
        try {
            String defaultType;
            String templateName = this.getStyles().get(releaseNoteStyleName);
            if (templateName == null && StringUtils.isNotBlank((String)(defaultType = this.applicationProperties.getDefaultBackedString(RELEASE_NOTE_DEFAULT)))) {
                templateName = this.getStyles().get(defaultType);
            }
            if (templateName == null) {
                templateName = this.getFirstStyle();
            }
            if (templateName == null) {
                log.error("No styles available for release notes");
                throw new IllegalArgumentException("No styles available for release notes");
            }
            Map<String, Object> templateVariables = this.getTemplateVariables(action, version, user, project);
            return this.templatingEngine.render(TemplateSources.file((String)(TEMPLATES_DIR + templateName))).applying(templateVariables).asHtml();
        }
        catch (VelocityException e) {
            log.error("Exception occurred while attempting to get velocity body for release note template.", (Throwable)e);
            return null;
        }
    }

    private String getFirstStyle() {
        Iterator<String> iterator;
        Collection<String> values = this.getStyles().values();
        if (values != null && (iterator = values.iterator()).hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private Map<String, Object> getTemplateVariables(Action action, Version version, ApplicationUser user, Project project) {
        ArrayList issueTypes = Lists.newArrayList();
        for (IssueType issueType : this.constantsManager.getAllIssueTypeObjects()) {
            issueTypes.add(new IssuesByType(issueType, user, version.getId()));
        }
        return MapBuilder.newBuilder().add((Object)"action", (Object)action).add((Object)"req", (Object)ExecutingHttpRequest.get()).add((Object)"issueTypes", (Object)issueTypes).add((Object)"appProps", (Object)this.applicationProperties).add((Object)"version", (Object)version.getName()).add((Object)"versionObj", (Object)version).add((Object)"project", (Object)project.getName()).add((Object)"textUtils", (Object)new TextUtils()).add((Object)"requestContext", (Object)new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext()).add((Object)"constantsManager", (Object)this.constantsManager).add((Object)"customFieldManager", (Object)this.customFieldManager).toMutableMap();
    }

    public class IssuesByType {
        private final IssueType issueType;
        private final ApplicationUser user;
        private final Long fixForVersion;
        private Collection<Issue> issues;

        private IssuesByType(IssueType issueType, @Nonnull ApplicationUser user, Long fixForVersion) {
            this.issueType = issueType;
            this.user = user;
            this.fixForVersion = (Long)Assertions.notNull((String)"fixForVersion", (Object)fixForVersion);
        }

        public String getName() {
            return this.issueType.getNameTranslation();
        }

        public Collection<Issue> getIssues() {
            if (this.issues == null) {
                JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
                queryBuilder.where().fixVersion(this.fixForVersion).and().issueType(new String[]{this.issueType.getId()});
                queryBuilder.orderBy().issueKey(SortOrder.ASC);
                try {
                    this.issues = ReleaseNoteManager.this.searchProvider.search(queryBuilder.buildQuery(), this.user, PagerFilter.getUnlimitedFilter()).getIssues();
                }
                catch (SearchException e) {
                    log.error("Error searching for issues", (Throwable)e);
                }
            }
            return this.issues;
        }
    }
}

