/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TenantInfo(value=TenantAware.UNRESOLVED)
@EventComponent
public class CachingProjectKeyStore
implements ProjectKeyStore {
    protected static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.CachingProjectKeyStore.caches.request";
    private final ProjectKeyStore delegateProjectKeyStore;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<ProjectKeyCache> cache;

    public CachingProjectKeyStore(ProjectKeyStore delegateProjectKeyStore, SwitchingCacheFactory cacheFactory) {
        this.delegateProjectKeyStore = delegateProjectKeyStore;
        this.cache = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".cache", () -> new ProjectKeyCache(delegateProjectKeyStore.getAllProjectKeys()), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
        this.refresh();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    @Nullable
    public Long getProjectId(String key) {
        return this.cache.get().getProjectId(key);
    }

    @Override
    public void addProjectKey(Long projectId, String projectKey) {
        this.delegateProjectKeyStore.addProjectKey(projectId, projectKey);
        this.refresh();
    }

    @Override
    public void deleteProjectKeys(Long projectId) {
        this.delegateProjectKeyStore.deleteProjectKeys(projectId);
        this.refresh();
    }

    @Override
    @Nonnull
    public Map<String, Long> getAllProjectKeys() {
        return this.cache.get().getAllProjectKeys();
    }

    @Override
    @Nullable
    public Long getProjectIdByKeyIgnoreCase(String projectKey) {
        return this.cache.get().getProjectIdByKeyIgnoreCase(projectKey);
    }

    @Override
    @Nonnull
    public Set<String> getProjectKeys(Long projectId) {
        return this.cache.get().getProjectKeys(projectId);
    }

    @Override
    public void refresh() {
        this.cache.reset();
    }

    static class ProjectKeyCache {
        private final ImmutableMap<String, Long> projectsByKey;
        private final ImmutableSetMultimap<Long, String> projectKeys;
        private final ImmutableMap<String, Long> projectsByKeyIgnoreCase;

        public ProjectKeyCache(Map<String, Long> projects) {
            HashMultimap tmpProjectKeys = HashMultimap.create();
            for (Map.Entry<String, Long> projectKey : projects.entrySet()) {
                tmpProjectKeys.put((Object)projectKey.getValue(), (Object)projectKey.getKey());
            }
            this.projectsByKey = ImmutableMap.copyOf(projects);
            this.projectKeys = ImmutableSetMultimap.copyOf((Multimap)tmpProjectKeys);
            this.projectsByKeyIgnoreCase = ImmutableSortedMap.copyOf(this.projectsByKey, (Comparator)String.CASE_INSENSITIVE_ORDER);
        }

        @Nullable
        public Long getProjectId(String key) {
            return (Long)this.projectsByKey.get((Object)key);
        }

        @Nonnull
        public Map<String, Long> getAllProjectKeys() {
            return this.projectsByKey;
        }

        @Nonnull
        public Set<String> getProjectKeys(Long projectId) {
            return this.projectKeys.get((Object)projectId);
        }

        @Nullable
        public Long getProjectIdByKeyIgnoreCase(String projectKey) {
            return (Long)this.projectsByKeyIgnoreCase.get((Object)projectKey);
        }
    }
}

