/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.ProjectChangedTimeDTO;
import com.atlassian.jira.model.querydsl.QProjectChangedTime;
import com.atlassian.jira.project.ProjectChangedTime;
import com.atlassian.jira.project.ProjectChangedTimeImpl;
import com.atlassian.jira.project.ProjectChangedTimeStore;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.Optional;

public class ProjectChangedTimeStoreImpl
implements ProjectChangedTimeStore {
    private final QueryDslAccessor queryDslAccessor;

    public ProjectChangedTimeStoreImpl(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public Optional<ProjectChangedTime> getProjectChangedTime(long projectId) {
        ProjectChangedTimeDTO projectChangedDto = this.queryDslAccessor.executeQuery(dbConnection -> (ProjectChangedTimeDTO)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QProjectChangedTime.PROJECT_CHANGED_TIME).from((Expression)QProjectChangedTime.PROJECT_CHANGED_TIME)).where((Predicate)QProjectChangedTime.PROJECT_CHANGED_TIME.projectId.eq((Object)projectId))).fetchOne());
        return Optional.ofNullable(projectChangedDto).map(ProjectChangedTimeImpl::new);
    }

    @Override
    public void updateOrAddIssueChangedTime(long projectId, Timestamp issueChangedTime) {
        this.queryDslAccessor.execute(dbConnection -> {
            long rowCount = dbConnection.update((RelationalPath<?>)QProjectChangedTime.PROJECT_CHANGED_TIME).set(QProjectChangedTime.PROJECT_CHANGED_TIME.issueChangedTime, (Object)issueChangedTime).where((Predicate)QProjectChangedTime.PROJECT_CHANGED_TIME.projectId.eq((Object)projectId)).execute();
            if (rowCount == 0L) {
                dbConnection.insert(QProjectChangedTime.PROJECT_CHANGED_TIME).set((Path)QProjectChangedTime.PROJECT_CHANGED_TIME.projectId, (Object)projectId).set((Path)QProjectChangedTime.PROJECT_CHANGED_TIME.issueChangedTime, issueChangedTime).execute();
            }
        });
    }
}

