/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.google.common.annotations.VisibleForTesting;

public class SmtpMailServerConfiguredCondition
extends AbstractWebCondition {
    public static boolean isOutgoingMailEnabled(MailSettings mailSettings) {
        return SmtpMailServerConfiguredCondition.isOutgoingMailEnabled(mailSettings, MailFactory.getServerManager());
    }

    @VisibleForTesting
    static boolean isOutgoingMailEnabled(MailSettings mailSettings, MailServerManager mailServerManager) {
        return !mailSettings.send().isDisabledViaApplicationProperty() && mailServerManager.getDefaultSMTPMailServer() != null;
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return SmtpMailServerConfiguredCondition.isOutgoingMailEnabled(this.getMailSettings());
    }

    MailSettings getMailSettings() {
        return (MailSettings)ComponentAccessor.getComponent(MailSettings.class);
    }
}

