/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractProjectPermissionCondition;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKey;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKeys;
import com.atlassian.jira.plugin.webfragment.conditions.cache.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasIssuePermissionCondition
extends AbstractProjectPermissionCondition {
    private static final Logger log = LoggerFactory.getLogger(HasIssuePermissionCondition.class);
    private final PermissionManager permissionManager;

    public HasIssuePermissionCondition(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper, ProjectPermissionKey permissionKey) {
        Map params = jiraHelper.getContextParams();
        Issue issue = (Issue)params.get("issue");
        if (issue == null) {
            log.warn("Trying to run permission condition on an issue, but no issue exists");
            return false;
        }
        return RequestCachingConditionHelper.cacheConditionResultInRequest((ConditionCacheKey)ConditionCacheKeys.permission((ProjectPermissionKey)permissionKey, (ApplicationUser)user, (Object[])new Object[]{issue}), () -> this.permissionManager.hasPermission(permissionKey, issue, user));
    }
}

