/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.icon;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.icon.IconTypePolicy;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserIconTypePolicy
implements IconTypePolicy {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;

    public UserIconTypePolicy(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
    }

    public boolean userCanView(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        String owningObjectID = icon.getOwner();
        if (owningObjectID == null) {
            return true;
        }
        if (remoteUser == null) {
            return false;
        }
        return icon.getIconType().equals((Object)IconType.USER_ICON_TYPE);
    }

    public boolean userCanDelete(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        return this.userCanCreateFor(remoteUser, new IconOwningObjectId(icon.getOwner()));
    }

    public boolean userCanCreateFor(@Nullable ApplicationUser remoteUser, @Nonnull IconOwningObjectId owningObjectId) {
        String user = owningObjectId.getId();
        if (user == null) {
            return false;
        }
        ApplicationUser owner = ApplicationUsers.byKey(user);
        return owner != null && owner.equals((Object)remoteUser) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, remoteUser);
    }
}

