/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ha;

import com.atlassian.jira.cluster.ClusterMessage;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.plugin.ha.MessageEventRegistry;
import com.atlassian.jira.plugin.ha.PluginOperation;
import com.atlassian.jira.plugin.ha.PluginSyncService;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultPluginSyncService
implements PluginSyncService {
    public static final String PLUGIN_CHANGE = "Plugin event";
    private final MessageEventRegistry eventRegistry;
    private final MessageConsumer messageConsumer;

    public DefaultPluginSyncService(MessageEventRegistry eventRegistry, ClusterMessagingService messagingService) {
        this.eventRegistry = eventRegistry;
        this.messageConsumer = new MessageConsumer(eventRegistry);
        messagingService.registerListener(PLUGIN_CHANGE, (ClusterMessageConsumer)this.messageConsumer);
    }

    @Override
    public void syncPlugins(@Nonnull List<ClusterMessage> pluginMessages) {
        Iterable operations = Iterables.transform(pluginMessages, (Function)new Function<ClusterMessage, PluginOperation>(){

            public PluginOperation apply(@Nullable ClusterMessage input) {
                if (input == null) {
                    return null;
                }
                return new PluginOperation(input.getMessage().getSupplementalInformation());
            }
        });
        this.firePluginEvents(operations);
    }

    private void firePluginEvents(Iterable<PluginOperation> filteredOperations) {
        for (PluginOperation operation : filteredOperations) {
            String completeKey = operation.getCompleteKey();
            Function<String, Void> eventFunction = this.eventRegistry.getEventFunction(operation.getPluginEventType());
            eventFunction.apply((Object)completeKey);
        }
    }

    private static class MessageConsumer
    implements ClusterMessageConsumer {
        private final MessageEventRegistry eventRegistry;

        public MessageConsumer(MessageEventRegistry eventRegistry) {
            this.eventRegistry = eventRegistry;
        }

        public void receive(String channel, String message, String senderId) {
            if (channel.equals(DefaultPluginSyncService.PLUGIN_CHANGE) && message != null) {
                PluginOperation operation = new PluginOperation(message);
                String completeKey = operation.getCompleteKey();
                Function<String, Void> eventFunction = this.eventRegistry.getEventFunction(operation.getPluginEventType());
                eventFunction.apply((Object)completeKey);
            }
        }
    }
}

