/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.dataprovider;

import com.atlassian.jira.security.AdminIssueLockoutFlagManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;

public class AdminIssueLockoutFlagDataProvider
implements WebResourceDataProvider {
    private static final Map<String, Object> DATA = ImmutableMap.of((Object)"noprojects", (Object)true, (Object)"manageAccessUrl", (Object)"secure/admin/ApplicationAccess.jspa", (Object)"flagId", (Object)"admin.lockout");
    private final Supplier<Delegate> delegateSupplier = Suppliers.memoize(() -> {
        AdminIssueLockoutFlagManager lockout = (AdminIssueLockoutFlagManager)locator.getComponent(AdminIssueLockoutFlagManager.class);
        JiraAuthenticationContext context = (JiraAuthenticationContext)locator.getComponent(JiraAuthenticationContext.class);
        return new Delegate(lockout, context);
    });

    @Inject
    public AdminIssueLockoutFlagDataProvider(ComponentLocator locator) {
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.getObject().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getObject() {
        if (((Delegate)this.delegateSupplier.get()).isAdminWithoutIssuePermission()) {
            return new JSONObject(DATA);
        }
        return new JSONObject();
    }

    private static class Delegate {
        private final AdminIssueLockoutFlagManager noAccessManager;
        private final JiraAuthenticationContext jiraAuthenticationContext;

        private Delegate(AdminIssueLockoutFlagManager noAccessManager, JiraAuthenticationContext jiraAuthenticationContext) {
            this.noAccessManager = noAccessManager;
            this.jiraAuthenticationContext = jiraAuthenticationContext;
        }

        private boolean isAdminWithoutIssuePermission() {
            ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
            return this.noAccessManager.isAdminWithoutIssuePermission(loggedInUser);
        }
    }
}

