/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.comment;

import com.atlassian.fugue.Option;
import com.atlassian.jira.plugin.comment.CommentFieldRendererModuleDescriptor;
import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.AbstractWebFragmentModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentFieldRendererModuleDescriptorImpl
extends AbstractWebFragmentModuleDescriptor<Void>
implements CommentFieldRendererModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(CommentFieldRendererModuleDescriptorImpl.class);
    private static final Supplier<Option<String>> emptySupplier = Suppliers.memoize((Supplier)new Supplier<Option<String>>(){

        public Option<String> get() {
            return Option.none();
        }
    });
    private final VelocityTemplatingEngine velocityTemplatingEngine;
    private final Map<String, Option<ResourceDescriptor>> resources = Maps.newHashMap();

    public CommentFieldRendererModuleDescriptorImpl(ModuleFactory moduleFactory, WebInterfaceManager webInterfaceManager, VelocityTemplatingEngine velocityTemplatingEngine) {
        super(moduleFactory, webInterfaceManager);
        this.velocityTemplatingEngine = velocityTemplatingEngine;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.initResources("field-edit", "field-view", "issue-page-edit", "issue-page-view");
    }

    private void initResources(String ... resourceIds) {
        for (String resourceId : resourceIds) {
            this.resources.put(resourceId, (Option<ResourceDescriptor>)Option.option((Object)this.getResourceDescriptor("velocity", resourceId)));
        }
    }

    public Option<String> getFieldEditHtml(Map<String, Object> context) {
        return (Option)this.resources.get("field-edit").fold(emptySupplier, (Function)new RenderCommentPanelFunction(context));
    }

    public Option<String> getFieldViewHtml(Map<String, Object> context) {
        return (Option)this.resources.get("field-view").fold(emptySupplier, (Function)new RenderCommentPanelFunction(context));
    }

    public Option<String> getIssuePageEditHtml(Map<String, Object> context) {
        return (Option)this.resources.get("issue-page-edit").fold(emptySupplier, (Function)new RenderCommentPanelFunction(context));
    }

    public Option<String> getIssuePageViewHtml(Map<String, Object> context) {
        return (Option)this.resources.get("issue-page-view").fold(emptySupplier, (Function)new RenderCommentPanelFunction(context));
    }

    public Void getModule() {
        throw new IllegalStateException("Get module on comment field renderer should never be called");
    }

    private String getHtml(ResourceDescriptor resourceDescriptor, Map<String, Object> context) {
        try {
            StringWriter sw = new StringWriter();
            TemplateSource templateSource = TemplateSources.file((String)(this.getCompleteKey() + "/" + resourceDescriptor.getLocation()));
            this.velocityTemplatingEngine.render(templateSource).applying(context).asHtml((Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            log.error("Error when rendering the comment field ", (Throwable)e);
            return "";
        }
    }

    private class RenderCommentPanelFunction
    implements Function<ResourceDescriptor, Option<String>> {
        private final Map<String, Object> context;

        public RenderCommentPanelFunction(Map<String, Object> context) {
            this.context = context;
        }

        public Option<String> apply(ResourceDescriptor resourceDescriptor) {
            Map contextMap = CommentFieldRendererModuleDescriptorImpl.this.getContextProvider().getContextMap(this.context);
            return Option.some((Object)CommentFieldRendererModuleDescriptorImpl.this.getHtml(resourceDescriptor, contextMap));
        }
    }
}

