/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.bigpipe;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.bigpipe.CollectingExecutor;
import com.atlassian.jira.util.Supplier;
import com.atlassian.json.marshal.wrapped.JsonableString;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;

public class BigPipeService {
    static final String FEATURE_BIG_PIPE = "com.atlassian.jira.config.BIG_PIPE";
    private static final String PER_REQUEST_EXECUTOR = "perRequestExecutor";
    private final WebResourceIntegration webResourceIntegration;
    private final PageBuilderService pageBuilderService;
    private final FeatureManager featureManager;

    public BigPipeService(WebResourceIntegration webResourceIntegration, PageBuilderService pageBuilderService, FeatureManager featureManager) {
        this.webResourceIntegration = webResourceIntegration;
        this.pageBuilderService = pageBuilderService;
        this.featureManager = featureManager;
    }

    public void pipeContent(@Nonnull String id, @Nullable Integer priority, @Nonnull Supplier<String> contentGenerator) {
        this.pageBuilderService.assembler().data().requireData(id, CompletableFuture.supplyAsync(() -> new JsonableString(StringEscapeUtils.escapeJson((String)((String)contentGenerator.get()))), this.perRequestExecutor().prioritized(priority)));
    }

    public boolean executeSingleTask() {
        return this.perRequestExecutor().pop().map(r -> {
            r.run();
            return true;
        }).orElse(false);
    }

    public void closeExecutor() {
        this.perRequestExecutor().close();
    }

    private CollectingExecutor perRequestExecutor() {
        CollectingExecutor executor = (CollectingExecutor)this.webResourceIntegration.getRequestCache().get(PER_REQUEST_EXECUTOR);
        if (executor == null) {
            executor = new CollectingExecutor();
            this.webResourceIntegration.getRequestCache().put(PER_REQUEST_EXECUTOR, executor);
        }
        return executor;
    }

    public boolean isBigPipeEnabled() {
        return this.featureManager.isEnabled(FEATURE_BIG_PIPE);
    }
}

