/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugin.JiraApplication;
import com.atlassian.jira.plugin.JiraFailedPluginTracker;
import com.atlassian.jira.plugin.MasterPluginFactory;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.factories.XmlDynamicPluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.RosterFilePluginLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.factory.RemotablePluginFactory;
import com.atlassian.plugin.osgi.factory.UnloadableStaticPluginFactory;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginFactoryAndLoaderRegistrar {
    private static final Logger log = LoggerFactory.getLogger(PluginFactoryAndLoaderRegistrar.class);
    private static final String BUNDLED_PLUGIN_LOCATION = "/WEB-INF/atlassian-bundled-plugins";
    private final PluginEventManager pluginEventManager;
    private final OsgiContainerManager osgiContainerManager;
    private final PluginPath pathFactory;
    private final ServletContextFactory servletContextFactory;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraFailedPluginTracker jiraFailedPluginTracker;
    private final JiraProperties jiraSystemProperties;

    PluginFactoryAndLoaderRegistrar(PluginEventManager pluginEventManager, OsgiContainerManager osgiContainerManager, PluginPath pathFactory, ServletContextFactory servletContextFactory, BuildUtilsInfo buildUtilsInfo, JiraFailedPluginTracker jiraFailedPluginTracker, JiraProperties jiraSystemProperties) {
        this.pluginEventManager = pluginEventManager;
        this.osgiContainerManager = osgiContainerManager;
        this.pathFactory = pathFactory;
        this.servletContextFactory = servletContextFactory;
        this.buildUtilsInfo = buildUtilsInfo;
        this.jiraFailedPluginTracker = jiraFailedPluginTracker;
        this.jiraSystemProperties = jiraSystemProperties;
    }

    public List<PluginFactory> getDefaultPluginFactories() {
        ArrayList everyPluginWhiteList = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile(".*")});
        return this.getDefaultPluginFactories(everyPluginWhiteList);
    }

    public List<PluginFactory> getDefaultPluginFactories(List<Pattern> pluginWhitelist) {
        Set<Application> jiraApplications = this.jiraApplications(this.buildUtilsInfo);
        OsgiPluginFactory osgiPluginFactory = new OsgiPluginFactory("atlassian-plugin.xml", jiraApplications, this.pathFactory.getOsgiPersistentCache(), this.osgiContainerManager, this.pluginEventManager);
        OsgiBundleFactory osgiBundleFactory = new OsgiBundleFactory(this.osgiContainerManager);
        RemotablePluginFactory remotablePluginFactory = new RemotablePluginFactory("atlassian-plugin.xml", jiraApplications, this.osgiContainerManager, this.pluginEventManager);
        XmlDynamicPluginFactory xmlDynamicFactory = new XmlDynamicPluginFactory(jiraApplications);
        UnloadableStaticPluginFactory unloadableStaticPluginFactory = new UnloadableStaticPluginFactory("atlassian-plugin.xml");
        ImmutableList pluginFactories = ImmutableList.of((Object)osgiPluginFactory, (Object)osgiBundleFactory, (Object)remotablePluginFactory, (Object)xmlDynamicFactory, (Object)unloadableStaticPluginFactory);
        MasterPluginFactory masterPluginFactory = new MasterPluginFactory((List<PluginFactory>)pluginFactories, pluginWhitelist, this.jiraFailedPluginTracker);
        return ImmutableList.of((Object)masterPluginFactory);
    }

    private Set<Application> jiraApplications(BuildUtilsInfo buildUtilsInfo) {
        return ImmutableSet.of((Object)new JiraApplication("jira", buildUtilsInfo), (Object)new JiraApplication("com.atlassian.jira", buildUtilsInfo));
    }

    public PluginLoader getBundledPluginsLoader(List<PluginFactory> pluginFactories) {
        String bundledPluginUrlString;
        String bundledPluginOverride = this.jiraSystemProperties.getProperty("jira.dev.bundledplugins.url");
        if (bundledPluginOverride != null) {
            bundledPluginUrlString = bundledPluginOverride;
            log.warn("Bundled plugins being loaded from override " + bundledPluginUrlString);
        } else {
            String bundledPluginPath = this.servletContextFactory.getServletContext().getRealPath(BUNDLED_PLUGIN_LOCATION);
            bundledPluginUrlString = new File(bundledPluginPath).toURI().toString();
        }
        File legacyBundledPluginsDirectory = this.pathFactory.getBundledPluginsDirectory();
        try {
            FileUtils.cleanDirectory((File)legacyBundledPluginsDirectory);
        }
        catch (IOException eio) {
            log.warn("Cannot clean '" + legacyBundledPluginsDirectory + "': " + eio.getMessage());
        }
        try {
            URL bundledPluginUrl = new URL(bundledPluginUrlString);
            return new BundledPluginLoader(bundledPluginUrl, legacyBundledPluginsDirectory, pluginFactories, this.pluginEventManager);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Can't form url to bundled plugins directory at: /WEB-INF/atlassian-bundled-plugins", e);
        }
    }

    public PluginLoader getCustomDirectoryPluginLoader(List<PluginFactory> pluginFactories) {
        File customPluginPath = this.pathFactory.getCustomPluginsDirectory();
        if (customPluginPath != null) {
            return new DirectoryPluginLoader(customPluginPath, pluginFactories, this.pluginEventManager);
        }
        return null;
    }

    public PluginLoader getRosterFilePluginLoader(List<PluginFactory> pluginFactories) {
        File rosterFile = this.pathFactory.getPluginsRosterFile();
        if (rosterFile != null) {
            return new RosterFilePluginLoader(rosterFile, pluginFactories, this.pluginEventManager);
        }
        return null;
    }

    public List<PluginLoader> getDefaultSystemPluginLoaders() {
        return Lists.newArrayList((Object[])new PluginLoader[]{new SinglePluginLoader("system-workflow-plugin.xml"), new SinglePluginLoader("system-customfieldtypes-plugin.xml"), new SinglePluginLoader("system-contentlinkresolvers-plugin.xml"), new SinglePluginLoader("system-renderercomponentfactories-plugin.xml"), new SinglePluginLoader("system-renderers-plugin.xml"), new SinglePluginLoader("system-macros-plugin.xml"), new SinglePluginLoader("system-issueoperations-plugin.xml"), new SinglePluginLoader("system-issuetabpanels-plugin.xml"), new SinglePluginLoader("system-comment-field-renderer.xml"), new SinglePluginLoader("webfragment/system-user-nav-bar-sections.xml"), new SinglePluginLoader("webfragment/system-admin-sections.xml"), new SinglePluginLoader("webfragment/system-preset-filters-sections.xml"), new SinglePluginLoader("webfragment/system-view-project-operations-sections.xml"), new SinglePluginLoader("webfragment/system-user-profile-links.xml"), new SinglePluginLoader("webfragment/system-hints.xml"), new SinglePluginLoader("system-issueviews-plugin.xml"), new SinglePluginLoader("system-projectroleactors-plugin.xml"), new SinglePluginLoader("system-webresources-plugin.xml"), new SinglePluginLoader("system-top-navigation-plugin.xml"), new SinglePluginLoader("system-feature-keys-plugin.xml"), new SinglePluginLoader("system-footer-plugin.xml"), new SinglePluginLoader("system-filter-deletion-warning-plugin.xml"), new SinglePluginLoader("system-user-format-plugin.xml"), new SinglePluginLoader("system-user-profile-panels.xml"), new SinglePluginLoader("system-jql-function-plugin.xml"), new SinglePluginLoader("system-keyboard-shortcuts-plugin.xml"), new SinglePluginLoader("system-global-permissions.xml"), new SinglePluginLoader("system-project-permissions.xml"), new SinglePluginLoader("webfragment/system-browse-project-operations-sections.xml"), new SinglePluginLoader("webfragment/system-workflowtransitiontabs-links.xml"), new SinglePluginLoader("system-helppaths-plugin.xml"), new SinglePluginLoader("system-attachment-processor-plugin.xml"), new SinglePluginLoader("system-webpanels-plugin.xml"), new SinglePluginLoader("system-soyfunction-plugin.xml"), new SinglePluginLoader("system-entity-property-conditions.xml"), new SinglePluginLoader("system-icontypes-plugin.xml")});
    }

    public List<PluginLoader> getBootstrapSystemPluginLoaders() {
        return ImmutableList.of((Object)new SinglePluginLoader("system-webresources-plugin.xml"), (Object)new SinglePluginLoader("system-helppaths-plugin.xml"), (Object)new SinglePluginLoader("atlassian-plugins-jira-issue-nav-plugin-mock.xml"), (Object)new SinglePluginLoader("atlassian-plugins-webresource-plugin-mock.xml"), (Object)new SinglePluginLoader("atlassian-plugins-webresource-rest-mock.xml"));
    }

    public PluginLoader getDirectoryPluginLoader(List<PluginFactory> pluginFactories) {
        return new DirectoryPluginLoader(this.pathFactory.getInstalledPluginsDirectory(), pluginFactories, this.pluginEventManager);
    }
}

