/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.ClusterAwareJiraPluginController;
import com.atlassian.jira.plugin.JiraFailedPluginTracker;
import com.atlassian.jira.plugin.JiraPluginSystemListener;
import com.atlassian.jira.plugin.PluginLoaderFactory;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.plugin.PluginVersionImpl;
import com.atlassian.jira.plugin.PluginVersionStore;
import com.atlassian.jira.plugin.component.ComponentModuleDescriptor;
import com.atlassian.jira.plugin.ha.PluginMessageSender;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.startup.JiraStartupPluginSystemListener;
import com.atlassian.jira.tenancy.PluginKeyPredicateLoader;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginRegistry;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.exception.PluginExceptionInterception;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import com.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picocontainer.MutablePicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraPluginManager
extends DefaultPluginManager
implements Startable,
ClusterAwareJiraPluginController {
    public static final String PLUGIN_LICENSE_REGISTRY = "plugin-license-registry-location";
    public static final String PLUGIN_LICENSE_TYPE_STORE = "plugin-license-store-location";
    private static final Logger log = LoggerFactory.getLogger(JiraPluginManager.class);
    private final PluginVersionStore pluginVersionStore;
    @ClusterSafe(value="This reference has no node-specific state")
    private final LazyReference<PluginMessageSender> pluginMessageSenderRef = new LazyReference<PluginMessageSender>(){

        protected PluginMessageSender create() throws Exception {
            return (PluginMessageSender)ComponentAccessor.getComponent(PluginMessageSender.class);
        }
    };
    private final JiraPluginSystemListener jiraPluginSystemListener;
    private final PluginPath pluginPath;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private volatile boolean inStartup = false;

    public JiraPluginManager(PluginAccessor pluginAccessor, PluginRegistry.ReadWrite pluginRegistry, PluginPersistentStateStore store, PluginLoaderFactory pluginLoaderFactory, ModuleDescriptorFactory moduleDescriptorFactory, PluginVersionStore pluginVersionStore, PluginEventManager pluginEventManager, PluginPath pluginPath, PluginKeyPredicateLoader pluginKeyPredicateLoader, JiraPluginSystemListener jiraPluginSystemListener, JiraFailedPluginTracker failedPluginTracker, EventPublisher eventPublisher) {
        super(JiraPluginManager.newBuilder().withPluginAccessor(pluginAccessor).withPluginRegistry(pluginRegistry).withStore(store).withPluginLoaders(pluginLoaderFactory.getPluginLoaders()).withModuleDescriptorFactory(moduleDescriptorFactory).withPluginEventManager(pluginEventManager).withDelayLoadOf((PluginPredicate)pluginKeyPredicateLoader.getPluginKeyPatternsPredicate()).withPluginExceptionInterception((PluginExceptionInterception)failedPluginTracker));
        this.pluginAccessor = pluginAccessor;
        this.pluginVersionStore = pluginVersionStore;
        this.jiraPluginSystemListener = jiraPluginSystemListener;
        this.pluginPath = pluginPath;
        this.eventPublisher = eventPublisher;
        this.setPluginInstaller((PluginInstaller)new JiraPluginInstaller(eventPublisher, pluginPath.getInstalledPluginsDirectory()));
    }

    public void start() throws PluginException {
        this.earlyStartup();
        this.lateStartup();
    }

    public void earlyStartup() throws PluginParseException, NotificationException {
        JiraStartupLogger.log().info((Object)"\n\n___ Starting the JIRA Plugin System _________________\n");
        this.inStartup = true;
        super.earlyStartup();
    }

    public void lateStartup() throws PluginParseException, NotificationException {
        super.lateStartup();
        this.storePluginVersions();
        this.inStartup = false;
        JiraStartupLogger.log().info((Object)"\n\n___ Plugin System Started _________________\n");
    }

    public void enablePlugins(String ... keys) {
        super.enablePlugins(keys);
        for (String key : keys) {
            this.processEnabledPlugin(key);
            ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginEnabledMessage(key);
        }
    }

    @Override
    public void enablePluginsLocalOnly(String ... keys) {
        super.enablePlugins(keys);
        for (String key : keys) {
            this.processEnabledPlugin(key);
        }
    }

    protected void addPlugins(PluginLoader loader, Collection<Plugin> pluginsToInstall) throws PluginParseException {
        JiraStartupPluginSystemListener.addPlugins(pluginsToInstall.size());
        super.addPlugins(loader, pluginsToInstall);
    }

    public String installPlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        String key = super.installPlugin(pluginArtifact);
        ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginInstalledMessage(key);
        return key;
    }

    @Override
    public String installPluginLocalOnly(PluginArtifact pluginArtifact) throws PluginParseException {
        return super.installPlugin(pluginArtifact);
    }

    public Set<String> installPlugins(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        Set keys = super.installPlugins(pluginArtifacts);
        for (String key : keys) {
            ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginInstalledMessage(key);
        }
        return keys;
    }

    @Override
    public Set<String> installPluginsLocalOnly(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        return super.installPlugins(pluginArtifacts);
    }

    @PluginEventListener
    public void onPluginEnabledEvent(PluginEnabledEvent enabledEvent) {
        Plugin plugin = enabledEvent.getPlugin();
        log.debug(String.format("Plugin with key '%s' has been enabled.", plugin.getKey()));
        if (!this.inStartup) {
            this.pluginVersionStore.save(new PluginVersionImpl(plugin.getKey(), plugin.getName(), plugin.getPluginInformation().getVersion(), new Date()));
        }
    }

    @PluginEventListener
    public void onPluginUninstalledEvent(PluginUninstalledEvent uninstalledEvent) {
        Plugin plugin = uninstalledEvent.getPlugin();
        String pluginKey = plugin.getKey();
        log.debug(String.format("Plugin with key '%s' has been uninstalled.", pluginKey));
        this.pluginVersionStore.deleteByKey(pluginKey);
        PluginArtifact pluginArtifact = plugin.getPluginArtifact();
        if (pluginArtifact != null) {
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.PLUGIN, new File(this.pluginPath.getInstalledPluginsDirectory(), pluginArtifact.getName())));
        }
    }

    @PluginEventListener
    public void onPluginDisabledEvent(PluginDisabledEvent disabledEvent) {
        Plugin plugin = disabledEvent.getPlugin();
        log.debug(String.format("Plugin with key '%s' has been disabled.", plugin.getKey()));
    }

    @PluginEventListener
    public void onPluginUpgradedEvent(PluginUpgradedEvent upgradedEvent) {
        ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginUpgradedMessage(upgradedEvent.getPlugin().getKey());
    }

    private void processEnabledPlugin(String key) {
        Plugin plugin = this.pluginAccessor.getPlugin(key);
        if (plugin != null) {
            Collection funNewComponents = this.pluginAccessor.getPlugin(key).getModuleDescriptors();
            if (!funNewComponents.isEmpty()) {
                for (ModuleDescriptor moduleDescriptor : funNewComponents) {
                    if (!ComponentModuleDescriptor.class.isInstance(moduleDescriptor) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
                    ComponentModuleDescriptor componentModuleDescriptor = (ComponentModuleDescriptor)moduleDescriptor;
                    componentModuleDescriptor.registerComponents(ComponentManager.getInstance().getMutablePicoContainer());
                }
            }
        } else {
            log.error("Could not enable plugin with key '" + key + "'");
        }
    }

    public void uninstall(Plugin plugin) throws PluginException {
        super.uninstall(plugin);
        ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginUninstalledMessage(plugin.getKey());
    }

    @Override
    public void uninstallLocalOnly(Plugin plugin) throws PluginException {
        super.uninstall(plugin);
    }

    public void disablePlugin(String key) {
        this.disablePluginLocalOnly(key);
        ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginDisabledMessage(key);
    }

    @Override
    public void disablePluginLocalOnly(String key) {
        this.unregisterComponents(key);
        super.disablePlugin(key);
        if (!ComponentManager.getInstance().getState().isPluginSystemStarted()) {
            log.warn("Disable Plugin with key '" + key + "' called before Plugin System Started.", (Throwable)new RuntimeException());
        }
    }

    public void disablePluginWithoutPersisting(String key) {
        this.unregisterComponents(key);
        super.disablePluginWithoutPersisting(key);
        if (ComponentManager.getInstance().getState().isPluginSystemStarted() && log.isDebugEnabled()) {
            log.debug("Disabling plugin with key  '" + key + "' without persisting. This should occur if this plugin depends on a plugin that is currently being upgraded");
        }
    }

    private void unregisterComponents(String key) {
        Plugin plugin = this.pluginAccessor.getPlugin(key);
        if (plugin == null) {
            log.warn(String.format("Attempted to unregister components for non existing plugin '%s'", key));
            return;
        }
        Collection funNewComponents = plugin.getModuleDescriptors();
        if (!funNewComponents.isEmpty()) {
            for (ModuleDescriptor moduleDescriptor : funNewComponents) {
                if (!ComponentModuleDescriptor.class.isInstance(moduleDescriptor) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
                ComponentModuleDescriptor componentModuleDescriptor = (ComponentModuleDescriptor)moduleDescriptor;
                componentModuleDescriptor.unregisterComponents(ComponentManager.getInstance().getMutablePicoContainer());
            }
        }
    }

    public void disablePluginModule(String completeKey) {
        this.disablePluginModuleLocalOnly(completeKey);
        ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginModuleDisabledMessage(completeKey);
    }

    @Override
    public void disablePluginModuleLocalOnly(String completeKey) {
        ModuleDescriptor moduleDescriptor = this.getEnabledPluginModule(completeKey);
        if (moduleDescriptor instanceof ComponentModuleDescriptor) {
            ((ComponentModuleDescriptor)moduleDescriptor).unregisterComponents((MutablePicoContainer)ComponentManager.getInstance().getContainer());
        }
        super.disablePluginModule(completeKey);
    }

    public void enablePluginModule(String completeKey) {
        this.enablePluginModuleLocalOnly(completeKey);
        ((PluginMessageSender)this.pluginMessageSenderRef.get()).sendPluginModuleEnabledMessage(completeKey);
    }

    @Override
    public void enablePluginModuleLocalOnly(String completeKey) {
        super.enablePluginModule(completeKey);
        ModuleDescriptor moduleDescriptor = this.getEnabledPluginModule(completeKey);
        if (moduleDescriptor instanceof ComponentModuleDescriptor) {
            ((ComponentModuleDescriptor)moduleDescriptor).registerComponents((MutablePicoContainer)ComponentManager.getInstance().getContainer());
        }
    }

    void storePluginVersions() {
        Map<String, PluginVersion> pluginVersionsByKey = this.getPluginVersionsByKey();
        for (Plugin plugin : this.pluginAccessor.getPlugins()) {
            this.storePluginVersion(plugin, pluginVersionsByKey.get(plugin.getKey()));
            pluginVersionsByKey.remove(plugin.getKey());
        }
        this.deletePluginVersions(pluginVersionsByKey.values());
    }

    void storePluginVersion(Plugin plugin, PluginVersion pluginVersion) {
        String pluginKey = plugin.getKey();
        PluginInformation pluginInformation = plugin.getPluginInformation();
        String version = "unknown";
        if (pluginInformation != null) {
            version = pluginInformation.getVersion();
        }
        if (pluginVersion == null) {
            if (log.isInfoEnabled()) {
                log.info("Plugin with key '" + pluginKey + "' and name '" + plugin.getName() + "' and version '" + version + "' is being added to the system.");
            }
            this.pluginVersionStore.create(new PluginVersionImpl(pluginKey, plugin.getName(), version, new Date()));
        } else if (!pluginVersion.getVersion().equals(version)) {
            if (log.isInfoEnabled()) {
                log.info("Plugin with key '" + pluginKey + "' and name '" + plugin.getName() + "' and version '" + pluginVersion.getVersion() + "' is being updated to version '" + version + "'.");
            }
            this.pluginVersionStore.update(new PluginVersionImpl(pluginVersion.getId(), pluginVersion.getKey(), plugin.getName(), version, new Date()));
        }
    }

    void deletePluginVersions(Collection<PluginVersion> pluginVersionsToDelete) {
        for (PluginVersion pluginVersion : pluginVersionsToDelete) {
            if (log.isInfoEnabled()) {
                log.info("Plugin with key '" + pluginVersion.getKey() + "' and name '" + pluginVersion.getName() + "' and version '" + pluginVersion.getVersion() + "' is being removed from the system.");
            }
            this.pluginVersionStore.delete(pluginVersion.getId());
        }
    }

    Map<String, PluginVersion> getPluginVersionsByKey() {
        HashMap<String, PluginVersion> versionsByKey = new HashMap<String, PluginVersion>();
        List<PluginVersion> pluginVersions = this.pluginVersionStore.getAll();
        for (PluginVersion pluginVersion : pluginVersions) {
            versionsByKey.put(pluginVersion.getKey(), pluginVersion);
        }
        return versionsByKey;
    }

    private static class JiraPluginInstaller
    extends FilePluginInstaller {
        private final EventPublisher eventPublisher;
        private final File installedPluginsDirectory;

        public JiraPluginInstaller(EventPublisher eventPublisher, File installedPluginsDirectory) {
            super(installedPluginsDirectory);
            this.eventPublisher = eventPublisher;
            this.installedPluginsDirectory = installedPluginsDirectory;
        }

        public void installPlugin(String key, PluginArtifact pluginArtifact) {
            super.installPlugin(key, pluginArtifact);
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.PLUGIN, new File(this.installedPluginsDirectory, pluginArtifact.getName())));
        }
    }
}

