/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management.beans;

import com.atlassian.jira.permission.management.beans.SecurityTypeBean;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ProjectPermissionBean {
    private String permissionKey;
    private String permissionName;
    private String permissionDesc;
    private List<SecurityTypeBean> grants;

    public ProjectPermissionBean() {
    }

    private ProjectPermissionBean(String permissionKey, String permissionName, String permissionDesc, Iterable<SecurityTypeBean> grants) {
        this.permissionKey = permissionKey;
        this.permissionName = permissionName;
        this.permissionDesc = permissionDesc;
        this.grants = grants != null ? ImmutableList.copyOf(grants) : null;
    }

    public String getPermissionKey() {
        return this.permissionKey;
    }

    public void setPermissionKey(String permissionKey) {
        this.permissionKey = permissionKey;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    public String getPermissionDesc() {
        return this.permissionDesc;
    }

    public void setPermissionDesc(String permissionDesc) {
        this.permissionDesc = permissionDesc;
    }

    public List<SecurityTypeBean> getGrants() {
        return this.grants;
    }

    public void setGrants(List<SecurityTypeBean> grants) {
        this.grants = grants != null ? ImmutableList.copyOf(grants) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectPermissionBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPermissionBean that = (ProjectPermissionBean)o;
        return Objects.equal((Object)this.permissionKey, (Object)that.permissionKey) && Objects.equal((Object)this.permissionName, (Object)that.permissionName) && Objects.equal((Object)this.permissionDesc, (Object)that.permissionDesc) && Objects.equal(this.grants, that.grants);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.permissionKey, this.permissionName, this.permissionDesc, this.grants});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("permissionKey", (Object)this.permissionKey).add("permissionName", (Object)this.permissionName).add("permissionDesc", (Object)this.permissionDesc).add("grants", this.grants).toString();
    }

    public static final class Builder {
        private String permissionKey;
        private String permissionName;
        private String permissionDesc;
        private List<SecurityTypeBean> grants = Lists.newArrayList();

        private Builder() {
        }

        private Builder(ProjectPermissionBean initialData) {
            this.permissionKey = initialData.permissionKey;
            this.permissionName = initialData.permissionName;
            this.permissionDesc = initialData.permissionDesc;
            this.grants = initialData.grants;
        }

        public Builder setPermissionKey(String permissionKey) {
            this.permissionKey = permissionKey;
            return this;
        }

        public Builder setPermissionName(String permissionName) {
            this.permissionName = permissionName;
            return this;
        }

        public Builder setPermissionDesc(String permissionDesc) {
            this.permissionDesc = permissionDesc;
            return this;
        }

        public Builder setGrants(List<SecurityTypeBean> grants) {
            this.grants = grants;
            return this;
        }

        public Builder addGrant(SecurityTypeBean grant) {
            this.grants.add(grant);
            return this;
        }

        public Builder addGrants(Iterable<SecurityTypeBean> grants) {
            for (SecurityTypeBean grant : grants) {
                this.addGrant(grant);
            }
            return this;
        }

        public ProjectPermissionBean build() {
            return new ProjectPermissionBean(this.permissionKey, this.permissionName, this.permissionDesc, this.grants);
        }
    }
}

