/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type.enterprise;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentLead
extends AbstractNotificationType {
    private static final Logger log = LoggerFactory.getLogger(ComponentLead.class);
    private final JiraAuthenticationContext authenticationContext;

    public ComponentLead(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.authenticationContext.getI18nHelper().getText("admin.projects.component.lead");
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        Issue issue = event.getIssue();
        if (issue == null) {
            return Collections.emptyList();
        }
        UserManager userManager = ComponentAccessor.getUserManager();
        HashSet<NotificationRecipient> recipients = new HashSet<NotificationRecipient>();
        for (ProjectComponent component : issue.getComponentObjects()) {
            String leadKey = component.getLead();
            ApplicationUser lead = userManager.getUserByKey(leadKey);
            if (lead != null) {
                recipients.add(new NotificationRecipient(lead));
                continue;
            }
            if (leadKey == null) continue;
            log.warn("Nonexistent user with key '" + leadKey + "' listed as component lead");
        }
        return new ArrayList<NotificationRecipient>(recipients);
    }
}

