/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.notification.type.ApplicationUserToRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.util.GroupSelectorUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCFValue
extends AbstractNotificationType {
    private static final Logger log = LoggerFactory.getLogger(GroupCFValue.class);
    public static final String ID = "Group_Custom_Field_Value";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GroupSelectorUtils groupSelectorUtils;
    private final FieldManager fieldManager;

    public GroupCFValue(JiraAuthenticationContext jiraAuthenticationContext, GroupSelectorUtils groupSelectorUtils, FieldManager fieldManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.groupSelectorUtils = groupSelectorUtils;
        this.fieldManager = fieldManager;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String customFieldId) {
        Collection<ApplicationUser> users = this.fromEventParams(event, customFieldId);
        if (users == null) {
            users = this.fromIssue(event, customFieldId);
        }
        return Lists.newArrayList((Iterable)Iterables.transform(users, (Function)ApplicationUserToRecipient.INSTANCE));
    }

    private Collection<ApplicationUser> fromEventParams(IssueEvent event, String customFieldId) {
        Object rawValue;
        Map customFieldValues = (Map)event.getParams().get(IssueEvent.CUSTOM_FIELDS_PARAM_NAME);
        if (customFieldValues != null && (rawValue = customFieldValues.get(customFieldId)) != null) {
            return this.groupSelectorUtils.getUsers(rawValue);
        }
        return null;
    }

    private List<ApplicationUser> fromIssue(IssueEvent event, String customFieldId) {
        try {
            return Lists.newArrayList(this.groupSelectorUtils.getUsers(event.getIssue(), customFieldId));
        }
        catch (IllegalArgumentException e) {
            log.warn("Returning empty list of e-mail recipients. Please remove any invalid custom fields from your notification schemes.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.group.custom.field.value");
    }

    @Override
    public String getType() {
        return "groupCF";
    }

    public List getFields() {
        return this.groupSelectorUtils.getCustomFieldsSpecifyingGroups();
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        String value = (String)parameters.get(key);
        if (value == null || value.length() == 0) {
            return false;
        }
        try {
            this.fieldManager.getCustomField(value);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    @Override
    public String getArgumentDisplay(String argument) {
        CustomField field = this.fieldManager.getCustomField(argument);
        return field.getName();
    }
}

