/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.notification.CustomFieldValueNotification;
import com.atlassian.jira.notification.EmailNotification;
import com.atlassian.jira.notification.EventNotifications;
import com.atlassian.jira.notification.GroupNotification;
import com.atlassian.jira.notification.Notification;
import com.atlassian.jira.notification.NotificationScheme;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.NotificationSchemeService;
import com.atlassian.jira.notification.ProjectRoleNotification;
import com.atlassian.jira.notification.RoleNotification;
import com.atlassian.jira.notification.UserNotification;
import com.atlassian.jira.notification.type.NotificationType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class DefaultNotificationSchemeService
implements NotificationSchemeService {
    public static final int MAX_PAGE_RESULT = 50;
    private final NotificationSchemeManager notificationSchemeManager;
    private final EventTypeManager eventTypeManager;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final CustomFieldManager customFieldManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;
    private final ProjectManager projectManager;

    public DefaultNotificationSchemeService(NotificationSchemeManager notificationSchemeManager, EventTypeManager eventTypeManager, UserManager userManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, CustomFieldManager customFieldManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, I18nHelper i18n, ProjectManager projectManager) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.eventTypeManager = eventTypeManager;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.customFieldManager = customFieldManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
        this.projectManager = projectManager;
    }

    public ServiceOutcome<NotificationScheme> getNotificationScheme(ApplicationUser user, @Nonnull Long id) {
        return this.withUserNotNullCheck(user, id, (applicationUser, schemeId) -> {
            Scheme scheme = this.notificationSchemeManager.getSchemeObject(schemeId);
            if (scheme == null) {
                return this.notificationSchemeDoesntExist((Long)schemeId);
            }
            if (!this.hasPermissions((ApplicationUser)applicationUser, scheme)) {
                return this.notificationSchemeDoesntExist((Long)schemeId);
            }
            return ServiceOutcomeImpl.ok(this.transformToNotificationScheme(scheme));
        });
    }

    public Page<NotificationScheme> getNotificationSchemes(ApplicationUser user, @Nonnull PageRequest pageRequest) {
        if (user == null) {
            return Pages.toPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        Predicate<Scheme> hasSchemePermissions = scheme -> this.hasPermissions(user, (Scheme)scheme);
        List schemeObjects = this.notificationSchemeManager.getSchemeObjects();
        return Pages.toPage((Iterable)schemeObjects, (PageRequest)PageRequests.limit((PageRequest)pageRequest, (int)50), hasSchemePermissions, this::transformToNotificationScheme);
    }

    public ServiceOutcome<NotificationScheme> getNotificationSchemeForProject(ApplicationUser user, @Nonnull Long projectId) {
        return this.withUserNotNullCheck(user, projectId, (applicationUser, id) -> {
            Project project = this.projectManager.getProjectObj(id);
            return this.getNotificationSchemeForProject((ApplicationUser)applicationUser, project);
        });
    }

    public ServiceOutcome<NotificationScheme> getNotificationSchemeForProject(ApplicationUser user, @Nonnull String projectKey) {
        return this.withUserNotNullCheck(user, projectKey, (applicationUser, key) -> {
            Project project = this.projectManager.getProjectObjByKey(key);
            return this.getNotificationSchemeForProject((ApplicationUser)applicationUser, project);
        });
    }

    private <T> ServiceOutcome<NotificationScheme> withUserNotNullCheck(ApplicationUser user, T id, BiFunction<ApplicationUser, T, ServiceOutcome<NotificationScheme>> function) {
        if (user != null) {
            return function.apply(user, (ApplicationUser)id);
        }
        return ServiceOutcomeImpl.error(this.i18n.getText("createissue.not.logged.in"), ErrorCollection.Reason.NOT_LOGGED_IN);
    }

    private ServiceOutcome<NotificationScheme> getNotificationSchemeForProject(ApplicationUser user, Project project) {
        if (project == null) {
            return ServiceOutcomeImpl.error(this.i18n.getText("common.share.project.does.not.exist"), ErrorCollection.Reason.NOT_FOUND);
        }
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) && !this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user)) {
            return ServiceOutcomeImpl.error(this.i18n.getText(this.i18n.getText("common.share.project.does.not.exist"), (Object)ErrorCollection.Reason.FORBIDDEN));
        }
        Scheme scheme = this.notificationSchemeManager.getSchemeFor(project);
        if (scheme != null) {
            return ServiceOutcomeImpl.ok(this.transformToNotificationScheme(scheme));
        }
        return ServiceOutcomeImpl.error(this.i18n.getText("admin.notifications.scheme.for.project.does.not.exist"), ErrorCollection.Reason.NOT_FOUND);
    }

    private NotificationScheme transformToNotificationScheme(Scheme scheme) {
        ImmutableListMultimap notificationEntitiesByEventType = Multimaps.index((Iterable)scheme.getEntities(), (Function)new Function<SchemeEntity, EventType>(){

            public EventType apply(SchemeEntity schemeEntity) {
                return DefaultNotificationSchemeService.this.eventTypeManager.getEventType((Long)schemeEntity.getEntityTypeId());
            }
        });
        ListMultimap notificationsByEventType = Multimaps.transformEntries((ListMultimap)notificationEntitiesByEventType, (Maps.EntryTransformer)new Maps.EntryTransformer<EventType, SchemeEntity, Option<Notification>>(){

            public Option<Notification> transformEntry(EventType key, SchemeEntity schemeEntity) {
                return DefaultNotificationSchemeService.this.createNotificationForSchemeEntity(schemeEntity);
            }
        });
        Iterable notificationEvents = Iterables.transform(notificationsByEventType.asMap().entrySet(), (Function)new Function<Map.Entry<EventType, Collection<Option<Notification>>>, EventNotifications>(){

            public EventNotifications apply(Map.Entry<EventType, Collection<Option<Notification>>> input) {
                ImmutableList notifications = ImmutableList.copyOf((Iterable)Options.flatten((Iterable)input.getValue()));
                return new EventNotifications(input.getKey(), (Iterable)notifications);
            }
        });
        return new NotificationScheme(scheme.getId(), scheme.getName(), scheme.getDescription(), notificationEvents);
    }

    private ServiceOutcome<NotificationScheme> notificationSchemeDoesntExist(Long id) {
        return ServiceOutcomeImpl.error(this.i18n.getText("admin.notifications.scheme.does.not.exist", (Object)id), ErrorCollection.Reason.NOT_FOUND);
    }

    private boolean hasPermissions(ApplicationUser user, Scheme scheme) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) || this.notificationSchemeManager.getProjects(scheme).stream().anyMatch(project -> this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user));
    }

    private Option<Notification> createNotificationForSchemeEntity(SchemeEntity schemeEntity) {
        NotificationType notificationType = NotificationType.from((String)schemeEntity.getType());
        Long schemeEntityId = schemeEntity.getId();
        String parameter = schemeEntity.getParameter();
        switch (notificationType) {
            case CURRENT_ASSIGNEE: 
            case REPORTER: 
            case CURRENT_USER: 
            case PROJECT_LEAD: 
            case COMPONENT_LEAD: 
            case ALL_WATCHERS: {
                return this.createRoleBasedNotification(notificationType, schemeEntityId);
            }
            case SINGLE_USER: {
                return this.createUserNotification(notificationType, schemeEntityId, parameter);
            }
            case GROUP: {
                return this.createGroupNotification(notificationType, schemeEntityId, parameter);
            }
            case PROJECT_ROLE: {
                return this.createProjectRoleNotification(notificationType, schemeEntityId, parameter);
            }
            case USER_CUSTOM_FIELD_VALUE: 
            case GROUP_CUSTOM_FIELD_VALUE: {
                return this.createCustomFieldNotification(notificationType, schemeEntityId, parameter);
            }
            case SINGLE_EMAIL_ADDRESS: {
                return this.createSingleEmailAddressNotification(schemeEntityId, parameter);
            }
        }
        return Option.none();
    }

    private Option<Notification> createSingleEmailAddressNotification(Long schemeEntityId, String parameter) {
        return Option.some((Object)new EmailNotification(schemeEntityId, parameter));
    }

    private Option<Notification> createRoleBasedNotification(NotificationType notificationType, Long schemeEntityId) {
        return Option.some((Object)new RoleNotification(schemeEntityId, notificationType));
    }

    private Option<Notification> createCustomFieldNotification(NotificationType notificationType, Long schemeEntityId, String customFieldId) {
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        return Option.some((Object)new CustomFieldValueNotification(schemeEntityId, notificationType, customField, customFieldId));
    }

    private Option<Notification> createProjectRoleNotification(NotificationType notificationType, Long schemeEntityId, String projectRoleId) {
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(Long.parseLong(projectRoleId)));
        return Option.some((Object)new ProjectRoleNotification(schemeEntityId, notificationType, projectRole, projectRoleId));
    }

    private Option<Notification> createGroupNotification(NotificationType notificationType, Long schemeEntityId, String groupName) {
        Group group = this.groupManager.getGroup(groupName);
        return Option.some((Object)new GroupNotification(schemeEntityId, notificationType, group, groupName));
    }

    private Option<Notification> createUserNotification(NotificationType notificationType, Long schemeEntityId, String userKey) {
        ApplicationUser userToNotify = this.userManager.getUserByKey(userKey);
        return Option.some((Object)new UserNotification(schemeEntityId, notificationType, userToNotify, userKey));
    }
}

