/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.message;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.message.MessageUtil;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.google.common.base.Function;
import java.net.URI;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageUtilImpl
implements MessageUtil {
    private final I18nHelper i18nHelper;
    private final HelpUrls helpUrls;
    private final ExternalLinkUtil externalLinkUtil;
    private final BaseUrl baseUrl;

    MessageUtilImpl(I18nHelper i18nHelper, HelpUrls helpUrls, ExternalLinkUtil externalLinkUtil, BaseUrl baseUrl) {
        this.i18nHelper = (I18nHelper)Assertions.notNull((String)"i18nHelper", (Object)i18nHelper);
        this.helpUrls = (HelpUrls)Assertions.notNull((String)"helpUrls", (Object)helpUrls);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
        this.baseUrl = (BaseUrl)Assertions.notNull((String)"baseUrl", (Object)baseUrl);
    }

    @Override
    @Nonnull
    public HelpUrl getUrl(String key) {
        return this.helpUrls.getUrl(key);
    }

    @Override
    @Nonnull
    public HelpUrl getDefaultUrl() {
        return this.helpUrls.getDefaultUrl();
    }

    @Override
    @Nonnull
    public Set<String> getUrlKeys() {
        return this.helpUrls.getUrlKeys();
    }

    @Override
    public String getExternalLink(String key) {
        return this.externalLinkUtil.getProperty(key);
    }

    @Override
    public String getExternalLink(String key, String value1) {
        return this.externalLinkUtil.getProperty(key, value1);
    }

    @Override
    public String getExternalLink(String key, String value1, String value2) {
        return this.externalLinkUtil.getProperty(key, value1, value2);
    }

    @Override
    public String getExternalLink(String key, String value1, String value2, String value3) {
        return this.externalLinkUtil.getProperty(key, value1, value2, value3);
    }

    @Override
    public String getExternalLink(String key, String value1, String value2, String value3, String value4) {
        return this.externalLinkUtil.getProperty(key, value1, value2, value3, value4);
    }

    @Override
    public String getExternalLink(String key, Object parameters) {
        return this.externalLinkUtil.getProperty(key, parameters);
    }

    @Override
    public String getAnchorTagWithInternalLink(String keyOfLink) {
        HelpUrl helpUrl = this.getUrl(keyOfLink);
        return String.format("<a href=\"%s%s\">%s</a>", this.getBaseUrl(), helpUrl.getUrl(), this.getText(helpUrl.getTitle()));
    }

    public Locale getLocale() {
        return this.i18nHelper.getLocale();
    }

    public ResourceBundle getDefaultResourceBundle() {
        return this.i18nHelper.getDefaultResourceBundle();
    }

    public String getUnescapedText(String key) {
        return this.i18nHelper.getUnescapedText(key);
    }

    public String getUntransformedRawText(String key) {
        return this.i18nHelper.getUntransformedRawText(key);
    }

    public boolean isKeyDefined(String key) {
        return this.i18nHelper.isKeyDefined(key);
    }

    public String getText(String key) {
        return this.i18nHelper.getText(key);
    }

    public String getText(String key, String value1) {
        return this.i18nHelper.getText(key, value1);
    }

    public String getText(String key, String value1, String value2) {
        return this.i18nHelper.getText(key, value1, value2);
    }

    public String getText(String key, String value1, String value2, String value3) {
        return this.i18nHelper.getText(key, value1, value2, value3);
    }

    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4);
    }

    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.i18nHelper.getText(key, value1, value2, value3);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4, value5);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4, value5, value6);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.i18nHelper.getText(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public String getText(String key, Object parameters) {
        return this.i18nHelper.getText(key, parameters);
    }

    public Set<String> getKeysForPrefix(String prefix) {
        return this.i18nHelper.getKeysForPrefix(prefix);
    }

    public ResourceBundle getResourceBundle() {
        return this.i18nHelper.getResourceBundle();
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl.getBaseUrl();
    }

    @Override
    @Nonnull
    public String getCanonicalBaseUrl() {
        return this.baseUrl.getCanonicalBaseUrl();
    }

    @Override
    public URI getBaseUri() {
        return this.baseUrl.getBaseUri();
    }

    @Override
    @Nullable
    public <I, O> O runWithStaticBaseUrl(@Nullable I input, @Nonnull Function<I, O> runnable) {
        return this.baseUrl.runWithStaticBaseUrl(input, runnable);
    }
}

