/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.mail.SubscriptionMailQueueItemFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionMailQueueItem
extends AbstractMailQueueItem {
    public static final String USER_KEY_COLUMN_NAME = "username";
    private static final Logger log = LoggerFactory.getLogger(SubscriptionMailQueueItem.class);
    public static final String ATTACHMENTS_MANAGER_KEY = "attachmentsManager";
    private final FilterSubscription subscription;
    private final Supplier<ApplicationUser> subscriptionCreator;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final SubscriptionMailQueueItemFactory mailQueueItemFactory;
    private final MailQueue mailQueue;

    SubscriptionMailQueueItem(FilterSubscription sub, UserManager userManager, GroupManager groupManager, MailQueue mailQueue, SubscriptionMailQueueItemFactory mailQueueItemFactory) {
        this.subscription = sub;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.mailQueue = mailQueue;
        this.mailQueueItemFactory = mailQueueItemFactory;
        this.subscriptionCreator = Lazy.supplier(() -> userManager.getUserByKey(this.subscription.getUserKey()));
    }

    public void send() throws MailException {
        Collection<Object> recipients;
        this.incrementSendCount();
        String groupName = this.subscription.getGroupName();
        if (StringUtils.isNotEmpty((String)groupName)) {
            Group group = this.userManager.getGroup(groupName);
            if (group == null) {
                log.warn("Group '{}' referenced in subscription '{}' of filter '{}' does not exist.", new Object[]{groupName, this.subscription.getId(), this.subscription.getFilterId()});
                recipients = Collections.emptySet();
            } else {
                recipients = new ArrayList(this.groupManager.getUsersInGroup(groupName, Boolean.valueOf(false)));
            }
        } else {
            String getKey = this.subscription.getUserKey();
            ApplicationUser user = this.getSubscriptionUser();
            if (user == null) {
                log.warn("User '{}' referenced in subscription '{}' of filter '{}' does not exist.", new Object[]{getKey, this.subscription.getId(), this.subscription.getFilterId()});
                recipients = Collections.emptySet();
            } else {
                recipients = Collections.singleton(user);
            }
        }
        for (ApplicationUser user : recipients) {
            this.mailQueue.addItem((MailQueueItem)this.mailQueueItemFactory.createSelfEvaluatingEmailQueueItem(this.subscription, user));
        }
    }

    private ApplicationUser getSubscriptionUser() {
        return (ApplicationUser)this.subscriptionCreator.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionMailQueueItem)) {
            return false;
        }
        SubscriptionMailQueueItem subscriptionMailQueueItem = (SubscriptionMailQueueItem)((Object)o);
        if (!this.subscription.equals(subscriptionMailQueueItem.subscription)) {
            return false;
        }
        return !(this.subscriptionCreator != null ? !this.subscriptionCreator.equals(subscriptionMailQueueItem.subscriptionCreator) : subscriptionMailQueueItem.subscriptionCreator != null);
    }

    public int hashCode() {
        int result = this.subscription.hashCode();
        result = 29 * result + (this.subscriptionCreator != null ? this.subscriptionCreator.hashCode() : 0);
        return result;
    }

    public String toString() {
        ApplicationUser subscriptionUser = this.getSubscriptionUser();
        return ((Object)((Object)this)).getClass().getName() + " owner: '" + String.valueOf(subscriptionUser) + "'";
    }
}

