/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlIssueKeySupport;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.MovedIssueValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class IssueIdValidator
implements ClauseValidator {
    private static final Logger log = LoggerFactory.getLogger(IssueIdValidator.class);
    public static final int MAX_FUNC_OPERANDS_CHECKED = 1;
    public static final int MAX_MANUAL_OPERANDS_CHECKED = 25;
    private final JqlOperandResolver operandResolver;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlIssueKeySupport issueKeySupport;
    private final JqlIssueSupport issueSupport;
    private final I18nHelper.BeanFactory i18nFactory;
    private final MovedIssueValidator movedIssueValidator;

    IssueIdValidator(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport, I18nHelper.BeanFactory i18nFactory, SupportedOperatorsValidator supportedOperatorsValidator, MovedIssueValidator movedIssueValidator) {
        this.issueSupport = issueSupport;
        this.issueKeySupport = (JqlIssueKeySupport)Assertions.notNull((String)"issueKeySupport", (Object)issueKeySupport);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.supportedOperatorsValidator = (SupportedOperatorsValidator)Assertions.notNull((String)"supportedOperatorsValidator", (Object)supportedOperatorsValidator);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.movedIssueValidator = (MovedIssueValidator)Assertions.notNull((String)"movedIssueValidator", (Object)movedIssueValidator);
    }

    public IssueIdValidator(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport, I18nHelper.BeanFactory i18nFactory, MovedIssueKeyStore moveIssueKeyStore) {
        this(operandResolver, issueKeySupport, issueSupport, i18nFactory, new SupportedOperatorsValidator(new Collection[]{SystemSearchConstants.forIssueKey().getSupportedOperators()}), new MovedIssueValidator(OperatorClasses.EQUALITY_OPERATORS, moveIssueKeyStore, i18nFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        Assertions.notNull((String)"terminalClause", (Object)terminalClause);
        UtilTimerStack.push((String)"IssueIdValidator.validate()");
        try {
            Operand operand;
            List values;
            MessageSet messages = this.supportedOperatorsValidator.validate(searcher, terminalClause);
            if (!messages.hasAnyErrors() && (values = this.operandResolver.getValues(searcher, operand = terminalClause.getOperand(), terminalClause)) != null) {
                this.validateBatch(searcher, terminalClause, values, messages);
            }
            MessageSet messageSet = messages;
            return messageSet;
        }
        finally {
            UtilTimerStack.pop((String)"IssueIdValidator.validate()");
        }
    }

    private void validateBatch(ApplicationUser searcher, @Nonnull TerminalClause terminalClause, List<QueryLiteral> values, MessageSet messages) {
        Operand operand = terminalClause.getOperand();
        HashSet<Long> numericLiterals = new HashSet<Long>();
        HashSet<String> stringLiterals = new HashSet<String>();
        for (QueryLiteral value : values) {
            if (!value.isEmpty()) {
                if (value.getLongValue() != null) {
                    numericLiterals.add(value.getLongValue());
                    continue;
                }
                if (value.getStringValue() != null) {
                    stringLiterals.add(value.getStringValue());
                    continue;
                }
                log.debug("Unknown QueryLiteral: " + value.toString());
                continue;
            }
            this.validateEmptyOperand(messages, searcher, terminalClause, value.getSourceOperand());
        }
        if (this.shouldCheckLiterals(numericLiterals.size(), operand)) {
            this.validateIssueIdsBatch(messages, numericLiterals, searcher, terminalClause, operand);
        }
        if (this.shouldCheckLiterals(stringLiterals.size(), operand)) {
            this.validateIssueKeysBatch(messages, stringLiterals, searcher, terminalClause, operand);
        }
    }

    private boolean shouldCheckLiterals(int size, Operand operand) {
        if (size <= 0) {
            return false;
        }
        if (this.operandResolver.isFunctionOperand(operand)) {
            return size <= 1;
        }
        return size <= 25;
    }

    private MessageSet validateEmptyOperand(MessageSet messageSet, ApplicationUser searcher, TerminalClause clause, Operand operand) {
        I18nHelper i18n = this.i18nFactory.getInstance(searcher);
        if (!this.operandResolver.isFunctionOperand(operand)) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.field.does.not.support.empty", clause.getName()));
        } else {
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.field.does.not.support.empty.from.func", clause.getName(), operand.getName()));
        }
        return messageSet;
    }

    private void validateIssueIdsBatch(MessageSet messages, Set<Long> issueIds, ApplicationUser searcher, TerminalClause clause, Operand operand) {
        Set missingIssues = this.issueSupport.getIdsOfMissingIssues(issueIds);
        for (Long missingIssue : missingIssues) {
            this.addErrorIssueIdNotFound(messages, missingIssue, searcher, clause, operand);
        }
    }

    private void addErrorIssueIdNotFound(MessageSet messages, Long issueId, ApplicationUser searcher, TerminalClause clause, Operand operand) {
        I18nHelper i18n = this.i18nFactory.getInstance(searcher);
        if (!this.operandResolver.isFunctionOperand(operand)) {
            messages.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.id", clause.getName(), issueId.toString()));
        } else {
            messages.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name.from.function", operand.getName(), clause.getName()));
        }
    }

    private void validateIssueKeysBatch(MessageSet messages, Set<String> issueKeys, ApplicationUser searcher, TerminalClause clause, Operand operand) {
        Set missingIssueKeys = this.issueSupport.getKeysOfMissingIssues(issueKeys);
        for (String missingIssueKey : missingIssueKeys) {
            this.addErrorIssueKeyNotFound(messages, missingIssueKey, searcher, clause, operand);
        }
        HashSet<String> validIssueKeys = new HashSet<String>(issueKeys);
        validIssueKeys.removeAll(missingIssueKeys);
        if (!validIssueKeys.isEmpty()) {
            messages.addMessageSet(this.movedIssueValidator.validate(searcher, validIssueKeys, clause));
        }
    }

    private void addErrorIssueKeyNotFound(MessageSet messages, String key, ApplicationUser searcher, TerminalClause clause, Operand operand) {
        I18nHelper i18n = this.i18nFactory.getInstance(searcher);
        boolean validIssueKey = this.issueKeySupport.isValidIssueKey(key);
        if (!this.operandResolver.isFunctionOperand(operand)) {
            if (validIssueKey) {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.noissue", key, clause.getName()));
            } else {
                messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.invalidissuekey", key, clause.getName()));
            }
        } else if (validIssueKey) {
            messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.noissue.from.func", operand.getName(), clause.getName()));
        } else {
            messages.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.invalidissuekey.from.func", operand.getName(), clause.getName()));
        }
    }

    private boolean skipPermissionCheck(Operand operand) {
        return this.operandResolver.isFunctionOperand(operand);
    }
}

