/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;

public class DefaultOperatorUsageValidator
implements OperatorUsageValidator {
    private final JqlOperandResolver operandResolver;
    private final I18nHelper.BeanFactory factory;

    public DefaultOperatorUsageValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory factory) {
        this.factory = (I18nHelper.BeanFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
    }

    public boolean check(ApplicationUser user, TerminalClause clause) {
        return this.validate(user, clause, null);
    }

    public MessageSet validate(ApplicationUser searcher, TerminalClause clause) {
        MessageSetImpl messages = new MessageSetImpl();
        this.validate(searcher, clause, (MessageSet)messages);
        return messages;
    }

    private boolean validate(ApplicationUser user, TerminalClause clause, MessageSet set) {
        boolean valid = true;
        Operand operand = clause.getOperand();
        if (this.operandResolver.isValidOperand(operand)) {
            Operator operator = clause.getOperator();
            boolean isList = this.operandResolver.isListOperand(operand);
            if (isList) {
                if (!OperatorClasses.LIST_ONLY_OPERATORS.contains(operator)) {
                    valid = false;
                    this.addError(user, set, "jira.jql.operator.usage.not.support.list", operator.getDisplayString(), operand.getDisplayString(), clause.getName());
                }
            } else if (OperatorClasses.LIST_ONLY_OPERATORS.contains(operator)) {
                valid = false;
                this.addError(user, set, "jira.jql.operator.usage.not.support.non.list", operator.getDisplayString(), operand.getDisplayString(), clause.getName());
            }
            if (this.operandResolver.isEmptyOperand(operand)) {
                if (!OperatorClasses.EMPTY_OPERATORS.contains(operator)) {
                    valid = false;
                    this.addError(user, set, "jira.jql.operator.usage.not.support.empty", operator.getDisplayString(), operand.getDisplayString(), clause.getName());
                }
            } else if (OperatorClasses.EMPTY_ONLY_OPERATORS.contains(operator)) {
                valid = false;
                this.addError(user, set, "jira.jql.operator.usage.is.only.supports.empty", operator.getDisplayString(), clause.getName());
            }
        }
        return valid;
    }

    private void addError(ApplicationUser searcher, MessageSet messageset, String key, Object ... values) {
        if (messageset != null) {
            I18nHelper i18n = this.factory.getInstance(searcher);
            messageset.addErrorMessage(i18n.getText(key, (Object)values));
        }
    }
}

