/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogImpl2;
import com.atlassian.jira.model.querydsl.QWorklog;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.QueryDSLProjectRoleFactory;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import java.sql.Timestamp;
import java.util.Date;

public class QueryDSLWorklogFactory {
    private final IssueManager issueManager;
    private final QueryDSLProjectRoleFactory queryDSLProjectRoleFactory;

    public QueryDSLWorklogFactory(IssueManager issueManager, QueryDSLProjectRoleFactory queryDSLProjectRoleFactory) {
        this.issueManager = issueManager;
        this.queryDSLProjectRoleFactory = queryDSLProjectRoleFactory;
    }

    public Worklog createWorklog(Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        Long issueId = (Long)tuple.get(QWorklog.WORKLOG.issue);
        Issue issueForId = this.getIssueForId(issueId);
        return this.createWorklog(issueForId, tuple);
    }

    public Worklog createWorklog(Issue issue, Tuple tuple) {
        Timestamp createdTimestamp = (Timestamp)tuple.get(QWorklog.WORKLOG.created);
        Timestamp updatedTimestamp = (Timestamp)tuple.get(QWorklog.WORKLOG.updated);
        Long roleLevel = (Long)tuple.get(QWorklog.WORKLOG.rolelevel);
        ProjectRole projectRole = roleLevel != null ? this.queryDSLProjectRoleFactory.createProjectRole(tuple) : null;
        Timestamp startDate = (Timestamp)tuple.get(QWorklog.WORKLOG.startdate);
        return new WorklogImpl2(issue, (Long)tuple.get(QWorklog.WORKLOG.id), (String)tuple.get((Expression)QWorklog.WORKLOG.author), (String)tuple.get((Expression)QWorklog.WORKLOG.body), startDate != null ? new Date(startDate.getTime()) : null, (String)tuple.get((Expression)QWorklog.WORKLOG.grouplevel), roleLevel, (Long)tuple.get(QWorklog.WORKLOG.timeworked), (String)tuple.get((Expression)QWorklog.WORKLOG.updateauthor), createdTimestamp != null ? new Date(createdTimestamp.getTime()) : null, updatedTimestamp != null ? new Date(updatedTimestamp.getTime()) : null, projectRole);
    }

    public Worklog createWorklogWithAliasedIdColumn(Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        Long issueId = (Long)tuple.get(QWorklog.WORKLOG.issue);
        Issue issueForId = this.getIssueForId(issueId);
        return this.createWorklogWithAliasedIdColumn(issueForId, tuple);
    }

    private Worklog createWorklogWithAliasedIdColumn(Issue issue, Tuple tuple) {
        Timestamp createdTimestamp = (Timestamp)tuple.get(QWorklog.WORKLOG.created);
        Timestamp updatedTimestamp = (Timestamp)tuple.get(QWorklog.WORKLOG.updated);
        Long roleLevel = (Long)tuple.get(QWorklog.WORKLOG.rolelevel);
        ProjectRole projectRole = roleLevel != null ? this.queryDSLProjectRoleFactory.createProjectRole(tuple) : null;
        Timestamp startDate = (Timestamp)tuple.get(QWorklog.WORKLOG.startdate);
        return new WorklogImpl2(issue, (Long)tuple.get((Expression)QWorklog.WORKLOG.id.as("WORKLOG_ID")), (String)tuple.get((Expression)QWorklog.WORKLOG.author), (String)tuple.get((Expression)QWorklog.WORKLOG.body), startDate != null ? new Date(startDate.getTime()) : null, (String)tuple.get((Expression)QWorklog.WORKLOG.grouplevel), roleLevel, (Long)tuple.get(QWorklog.WORKLOG.timeworked), (String)tuple.get((Expression)QWorklog.WORKLOG.updateauthor), createdTimestamp != null ? new Date(createdTimestamp.getTime()) : null, updatedTimestamp != null ? new Date(updatedTimestamp.getTime()) : null, projectRole);
    }

    private Issue getIssueForId(Long issueId) {
        return this.issueManager.getIssueObject(issueId);
    }
}

