/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util.csv;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.views.util.csv.CsvDateFormatter;
import java.util.Date;
import javax.annotation.Nullable;

public class CsvDateFormatterImpl
implements CsvDateFormatter {
    private final DateTimeFormatterFactory formatterFactory;

    public CsvDateFormatterImpl(DateTimeFormatterFactory formatterFactory) {
        this.formatterFactory = formatterFactory;
    }

    @Override
    @Nullable
    public String formatDateTime(@Nullable Date date) {
        return this.format(this.formatterFactory.formatter().forLoggedInUser(), date);
    }

    @Override
    @Nullable
    public String formatDate(@Nullable Date date) {
        return this.format(this.formatterFactory.formatter().forLoggedInUser().withSystemZone(), date);
    }

    private String format(DateTimeFormatter formatter, Date date) {
        return date != null ? formatter.withStyle(DateTimeStyle.COMPLETE).format(date) : null;
    }
}

