/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.SingleIssueWriter;
import com.atlassian.jira.issue.views.util.IssueWriterHitCollector;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssueTableWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;

public class DefaultSearchRequestViewBodyWriterUtil
implements SearchRequestViewBodyWriterUtil {
    private final SearchProviderFactory searchProviderFactory;
    private final IssueFactory issueFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchProvider searchProvider;

    public DefaultSearchRequestViewBodyWriterUtil(SearchProviderFactory searchProviderFactory, IssueFactory issueFactory, JiraAuthenticationContext authenticationContext, SearchProvider searchProvider) {
        this.searchProviderFactory = searchProviderFactory;
        this.issueFactory = issueFactory;
        this.authenticationContext = authenticationContext;
        this.searchProvider = searchProvider;
    }

    @Override
    public void writeBody(Writer writer, final AbstractIssueView issueView, SearchRequest searchRequest, final SingleIssueWriter singleIssueWriter, PagerFilter pagerFilter) throws IOException, SearchException {
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        IssueWriterHitCollector hitCollector = new IssueWriterHitCollector(searcher, writer, this.issueFactory){

            @Override
            protected void writeIssue(Issue issue, Writer writer) throws IOException {
                singleIssueWriter.writeIssue(issue, issueView, writer);
            }
        };
        this.searchAndSort(searchRequest, (Collector)hitCollector, pagerFilter);
    }

    @Override
    public void writeTableBody(Writer writer, final IssueTableWriter issueTableWriter, SearchRequest searchRequest, PagerFilter pagerFilter) throws IOException, SearchException {
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        IssueWriterHitCollector hitCollector = new IssueWriterHitCollector(searcher, writer, this.issueFactory){

            @Override
            protected void writeIssue(Issue issue, Writer writer) throws IOException {
                issueTableWriter.write(issue);
            }
        };
        this.searchAndSort(searchRequest, (Collector)hitCollector, pagerFilter);
        issueTableWriter.close();
    }

    @Override
    public void searchAndSort(SearchRequest searchRequest, Collector collector, PagerFilter pagerFilter) throws SearchException {
        this.searchProvider.searchAndSort(searchRequest != null ? searchRequest.getQuery() : null, this.authenticationContext.getLoggedInUser(), collector, pagerFilter);
    }

    @Override
    public long searchCount(SearchRequest searchRequest) throws SearchException {
        return this.searchProvider.searchCount(searchRequest != null ? searchRequest.getQuery() : null, this.authenticationContext.getUser());
    }
}

