/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.csv;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.export.customfield.CsvIssueExporter;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.issue.views.util.WordViewUtils;
import com.atlassian.jira.plugin.searchrequestview.AbstractSearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.RuntimeIOException;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public abstract class AbstractCsvSearchRequestView
extends AbstractSearchRequestView {
    private final ApplicationProperties applicationProperties;
    protected final CsvIssueExporter csvIssueExporter;

    public AbstractCsvSearchRequestView(ApplicationProperties applicationProperties, CsvIssueExporter csvIssueExporter) {
        this.applicationProperties = applicationProperties;
        this.csvIssueExporter = csvIssueExporter;
    }

    public void writeHeaders(SearchRequest searchRequest, RequestHeaders requestHeaders, SearchRequestParams searchRequestParams) {
        WordViewUtils.writeGenericNoCacheHeaders(requestHeaders);
        WordViewUtils.writeEncodedAttachmentFilenameHeader(requestHeaders, JiraUrlCodec.encode((String)SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getDefaultBackedString("jira.title")), (boolean)true) + ".csv", searchRequestParams.getUserAgent(), this.applicationProperties.getEncoding());
    }

    public void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer) throws SearchException {
        try {
            List<Field> fields = this.getFieldsToBeExported(searchRequest);
            this.csvIssueExporter.export(writer, searchRequest, searchRequestParams, fields);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected abstract List<Field> getFieldsToBeExported(SearchRequest var1);
}

